/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import nom.tam.util.BufferedFile;
import org.lsst.ccs.utilities.ccd.image.data.RawImageData;
import org.lsst.ccs.utilities.image.CompositeFitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.DateUtils;
import org.lsst.ccs.utilities.image.FitsCheckSum;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.FitsHeadersSpecifications;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.MetaDataSet;

public class FitsFileWriter
implements Closeable {
    private BufferedFile bf;
    private ImageExtension[] imageExtensions;

    private void initializeFitsFileWriter(File file, ImageSet images, MetaDataSet metaDataSet, Map<String, HeaderSpecification> config, List<FitsHeaderMetadataProvider> providers, RawImageData.BitsPerPixel bits) throws IOException, FitsException {
        ArrayList<FitsHeaderMetadataProvider> inner_providers = new ArrayList<FitsHeaderMetadataProvider>();
        if (providers != null) {
            inner_providers.addAll(providers);
        }
        CompositeFitsHeaderMetadataProvider inner_provider = new CompositeFitsHeaderMetadataProvider(inner_providers);
        this.imageExtensions = new ImageExtension[images.getNumberOfImages()];
        int[][] intDummyData = new int[1][1];
        short[][] shortDummyData = new short[1][1];
        Object[] tableDummyData = new Object[]{};
        Object dummyData = bits == RawImageData.BitsPerPixel.BIT16 ? shortDummyData : (Object)intDummyData;
        this.bf = new BufferedFile(file, "rw");
        FitsFactory.setUseHierarch(true);
        MetaDataSet fullMetaData = inner_provider.getPrimaryHeaderMetadata();
        if (metaDataSet != null) {
            fullMetaData.addMetaDataSet(metaDataSet);
        }
        BasicHDU<?> primary = BasicHDU.getDummyHDU();
        this.addMetaDataToHeader(primary, "primary", fullMetaData, config);
        FitsCheckSum.setChecksum(primary);
        primary.getHeader().write(this.bf);
        int serialPixels = images.getSerialPixels();
        int parallelPixels = images.getParallelPixels();
        for (int i = 0; i < images.getNumberOfImages(); ++i) {
            BasicHDU<?> hdu = FitsFactory.HDUFactory(dummyData);
            MetaDataSet extendedMetadata = inner_provider.getDataExtendedHeaderMetadata(i);
            if (metaDataSet != null) {
                extendedMetadata.addMetaDataSet(metaDataSet);
            }
            extendedMetadata.addMetaData("extension", "NAXIS", 2);
            extendedMetadata.addMetaData("extension", "NAXIS1", images.getSerialPixels());
            extendedMetadata.addMetaData("extension", "NAXIS2", images.getParallelPixels());
            this.addMetaDataToHeader(hdu, "extended", extendedMetadata, config);
            if (bits == RawImageData.BitsPerPixel.BIT16) {
                hdu.addValue("BSCALE", 1.0, "Unsigned 16 bit data");
                hdu.addValue("BZERO", 32768, "Unsigned 16 bit data");
            } else {
                hdu.addValue("BSCALE", 1.0, "");
                hdu.addValue("BZERO", 0.0, "");
            }
            Header header = hdu.getHeader();
            header.setXtension("IMAGE");
            FitsCheckSum.setChecksum(hdu);
            long startHeader = this.bf.getFilePointer();
            header.write(this.bf);
            long startData = this.bf.getFilePointer();
            long imageSize = bits.bytes() * serialPixels * parallelPixels;
            this.bf.seek(this.bf.getFilePointer() + imageSize);
            FitsUtil.pad(this.bf, imageSize);
            this.imageExtensions[i] = new ImageExtension(file, startHeader, startData, imageSize, header);
        }
        FitsFactory.setUseAsciiTables(false);
        for (String key : config.keySet()) {
            if ("primary".equals(key) || "extended".equals(key)) continue;
            BasicHDU<?> binary = FitsFactory.HDUFactory(tableDummyData);
            MetaDataSet additionalMetaData = inner_provider.getAdditionalExtendedHeaderMetadata(key);
            if (metaDataSet != null) {
                additionalMetaData.addMetaDataSet(metaDataSet);
            }
            this.addMetaDataToHeader(binary, key, additionalMetaData, config);
            Header header = binary.getHeader();
            header.setXtension("BINTABLE");
            FitsCheckSum.setChecksum(binary);
            header.write(this.bf);
        }
    }

    @Deprecated
    public FitsFileWriter(File file, ImageSet images) throws IOException, FitsException {
        this(file, images, null, null, RawImageData.BitsPerPixel.BIT32);
    }

    public FitsFileWriter(File file, ImageSet images, Map<String, HeaderSpecification> specs) throws IOException, FitsException {
        this(file, images, null, null, RawImageData.BitsPerPixel.BIT32, specs);
    }

    @Deprecated
    public FitsFileWriter(File file, ImageSet images, MetaDataSet metaDataSet) throws IOException, FitsException {
        this(file, images, metaDataSet, null, RawImageData.BitsPerPixel.BIT32);
    }

    public FitsFileWriter(File file, ImageSet images, Map<String, HeaderSpecification> specs, MetaDataSet metaDataSet) throws IOException, FitsException {
        this(file, images, metaDataSet, null, RawImageData.BitsPerPixel.BIT32, specs);
    }

    public FitsFileWriter(File file, ImageSet images, MetaDataSet metaDataSet, List<FitsHeaderMetadataProvider> providers) throws IOException, FitsException {
        this(file, images, metaDataSet, providers, RawImageData.BitsPerPixel.BIT32);
    }

    @Deprecated
    public FitsFileWriter(File file, ImageSet images, List<FitsHeaderMetadataProvider> providers) throws IOException, FitsException {
        this(file, images, null, providers, RawImageData.BitsPerPixel.BIT32);
    }

    public FitsFileWriter(File file, ImageSet images, Map<String, HeaderSpecification> specs, List<FitsHeaderMetadataProvider> providers) throws IOException, FitsException {
        this(file, images, null, providers, RawImageData.BitsPerPixel.BIT32, specs);
    }

    @Deprecated
    public FitsFileWriter(File file, ImageSet images, MetaDataSet metaDataSet, List<FitsHeaderMetadataProvider> providers, RawImageData.BitsPerPixel bits) throws IOException, FitsException {
        this.initializeFitsFileWriter(file, images, metaDataSet, FitsHeadersSpecifications.getHeaderSpecifications(), providers, bits);
    }

    public FitsFileWriter(File file, ImageSet images, MetaDataSet metaDataSet, List<FitsHeaderMetadataProvider> providers, RawImageData.BitsPerPixel bits, Map<String, HeaderSpecification> specs) throws IOException, FitsException {
        this.initializeFitsFileWriter(file, images, metaDataSet, specs, providers, bits);
    }

    public int write(int imageIndex, ByteBuffer src) throws IOException {
        Future write = this.imageExtensions[imageIndex].write(src);
        try {
            return (Integer)write.get();
        }
        catch (ExecutionException x) {
            Throwable cause = x.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException("Exception while writing FITS file", x);
        }
        catch (InterruptedException x) {
            throw new InterruptedIOException("Interupt while writing FITS file");
        }
    }

    public Future<Integer> asyncWrite(int imageIndex, ByteBuffer src) throws IOException {
        return this.imageExtensions[imageIndex].write(src);
    }

    public <A> void asyncWrite(int imageIndex, ByteBuffer src, A attachment, CompletionHandler<Integer, ? super A> handler) throws IOException {
        this.imageExtensions[imageIndex].write(src, attachment, handler);
    }

    @Override
    public void close() throws IOException {
        for (ImageExtension imageExtension : this.imageExtensions) {
            imageExtension.close();
        }
        this.bf.close();
    }

    private void addMetaDataToHeader(BasicHDU hdu, String specName, MetaDataSet metaDataSet, Map<String, HeaderSpecification> config) throws HeaderCardException, IOException {
        HeaderSpecification spec = config.get(specName);
        if (spec == null) {
            throw new IOException("Missing specification for header: " + specName);
        }
        for (HeaderSpecification.HeaderLine header : spec.getHeaders()) {
            Object value = header.getValue(metaDataSet);
            try {
                if (value == null) continue;
                switch (header.getDataType()) {
                    case Integer: {
                        hdu.addValue(header.getKeyword(), ((Number)value).intValue(), header.getComment());
                        break;
                    }
                    case Float: {
                        double data = ((Number)value).doubleValue();
                        if (!Double.isFinite(data)) {
                            throw new IllegalArgumentException("Can not store non-finite floating point in FITS file");
                        }
                        hdu.addValue(header.getKeyword(), data, header.getComment());
                        break;
                    }
                    case Boolean: {
                        hdu.addValue(header.getKeyword(), (Boolean)value, header.getComment());
                        break;
                    }
                    case Date: {
                        hdu.addValue(header.getKeyword(), DateUtils.convertDateToString(value), header.getComment());
                        break;
                    }
                    case MJD: {
                        hdu.addValue(header.getKeyword(), DateUtils.convertDateToMJD(value), header.getComment());
                        break;
                    }
                    default: {
                        hdu.addValue(header.getKeyword(), String.valueOf(value), header.getComment());
                    }
                }
            }
            catch (ClassCastException x) {
                throw new IOException(String.format("Meta-data header %s with value %s(%s) cannot be converted to type %s", new Object[]{header.getKeyword(), value, value.getClass(), header.getDataType()}));
            }
            catch (IllegalArgumentException | HeaderCardException x) {
                throw new IOException(String.format("Meta-data header %s with value %s(%s) cannot be written", header.getKeyword(), value, value.getClass()), x);
            }
        }
    }

    private class ImageExtension
    implements Closeable {
        private final long startHeader;
        private final long endPosition;
        private long currentPosition;
        private final FitsCheckSum.Checksum checkSum;
        private final Header header;
        private final AsynchronousFileChannel asynchChannel;
        private final File file;

        private ImageExtension(File file, long startHeader, long startData, long imageSize, Header header) throws IOException {
            this.startHeader = startHeader;
            this.currentPosition = startData;
            this.endPosition = startData + imageSize;
            this.header = header;
            this.checkSum = new FitsCheckSum.Checksum();
            this.file = file;
            this.asynchChannel = AsynchronousFileChannel.open(file.toPath(), StandardOpenOption.WRITE);
        }

        private synchronized Future<Integer> write(ByteBuffer src) throws IOException {
            int length = src.remaining();
            if ((long)length + this.currentPosition > this.endPosition) {
                throw new IOException("Too much data written for image " + length + " " + this.currentPosition + " " + this.endPosition);
            }
            FitsCheckSum.updateChecksum(src, this.checkSum);
            Future<Integer> future = this.asynchChannel.write(src, this.currentPosition);
            this.currentPosition += (long)length;
            return future;
        }

        private synchronized <A> void write(ByteBuffer src, A attachment, CompletionHandler<Integer, ? super A> handler) throws IOException {
            int length = src.remaining();
            if ((long)length + this.currentPosition > this.endPosition) {
                throw new IOException("Too much data written for image " + length + " " + this.currentPosition + " " + this.endPosition);
            }
            FitsCheckSum.updateChecksum(src, this.checkSum);
            this.asynchChannel.write(src, this.currentPosition, attachment, handler);
            this.currentPosition += (long)length;
        }

        private synchronized void updateDataSum() throws IOException {
            try (BufferedFile extensionBufferedFile = new BufferedFile(this.file, "rw");){
                FitsCheckSum.updateDataSum(this.header, this.checkSum.getCheckSum());
                extensionBufferedFile.seek(this.startHeader);
                this.header.write(extensionBufferedFile);
            }
            catch (FitsException ex) {
                throw new IOException("Unable to add datasum to header", ex);
            }
        }

        @Override
        public void close() throws IOException {
            this.asynchChannel.close();
            this.updateDataSum();
        }
    }
}

