/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.utilities.ccd.CCDGeometryConstants;
import org.lsst.ccs.utilities.ccd.E2VCCDType;
import org.lsst.ccs.utilities.ccd.ITLCCDType;
import org.lsst.ccs.utilities.ccd.WFCCDType;

public class CCDType {
    private final CCDGeometryConstants ccdGeometryConstants;
    private final String name;
    private final String type;
    private static final List<CCDType> knownTypes = new ArrayList<CCDType>();

    protected CCDType(String name, String type, CCDGeometryConstants ccdGeometryConstants) {
        this.ccdGeometryConstants = ccdGeometryConstants;
        this.name = name;
        this.type = type;
    }

    public CCDGeometryConstants getCCDGeometryConstants() {
        return this.ccdGeometryConstants;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public static CCDType getCCDType(String name) {
        for (CCDType type : knownTypes) {
            if (!type.getName().toLowerCase().equals(name.toLowerCase())) continue;
            return type;
        }
        throw new IllegalArgumentException("No known CCDType is available with name \"" + name + "\"");
    }

    public static void registerCCDType(CCDType type) {
        knownTypes.add(type);
    }

    static {
        knownTypes.add(new ITLCCDType());
        knownTypes.add(new E2VCCDType());
        knownTypes.add(new WFCCDType());
    }
}

