package org.lsst.ccs.config;

import java.util.List;

/**
 * A class meant to process a stack of parameter values, as defined when
 * loading multiple tags, and return a single parameter value.
 * 
 * @author The LSST CCS Team
 */
public interface ConfigurationParameterDataChainProcessor {
    

    /**
     * The parameter path.
     * @return The parameter path
     */
    public String getParameterPath();
    
    /**
     * The parameter category.
     * @return The parameter category
     */
    public String getParameterCategory();
    
    /**
     * Process a List of values and return the String representation.
     * @param list
     * @return 
     */
    public String processDataChain(List<String> list);

    /**
     * Process a List of values and return the corresponding Object.
     * @param list
     * @return 
     */
    public Object processDataChainToObject(List<String> list);

}
