package org.lsst.ccs.config;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/**
 * A class containing the loaded configuration data.
 * It contains CategoryDataChain classes that order the data as it was loaded
 * and it assign each value the SingleCategoryTag from which it originated.
 * 
 * @author The LSST CCS Team
 */
public class ConfigurationLoadedData {
    
    public final Map<String,CategoryDataChain> categoryDataChainMap = new ConcurrentHashMap<>();
    
    public void putCategoryDataChain(CategoryDataChain categoryDataChain) {
        String category = categoryDataChain.getCategory();
        synchronized(categoryDataChainMap) {
//            if (categoryDataChainMap.containsKey(category)) {
//                categoryDataChainMap.get(category).addCategoryDataChain(categoryDataChain);
//            } else {
                categoryDataChainMap.put(category, categoryDataChain);
//            }
        }
    }
    
    public void putConfigurationLoadedData(ConfigurationLoadedData loadedData) {
        categoryDataChainMap.putAll(loadedData.categoryDataChainMap);
    }
    
    public ConfigurationDescription getConfigurationDescription() {
        synchronized(categoryDataChainMap) {
        ConfigurationDescription confDescription = new ConfigurationDescription(categoryDataChainMap.keySet());
            for (CategoryDataChain catDataChain : categoryDataChainMap.values()) {
                for ( SingleCategoryTag tag: catDataChain.getSingleCategoryTagList() ) {
                    confDescription.putSingleTagForCategory(catDataChain.getCategory(), tag, tag.getVersion());
                }
            }
        return confDescription;
        }
    }
    
    public final Set<String> getCategories() {
        return categoryDataChainMap.keySet();
    }
    
    public CategoryDataChain getLoadedDataForCategory(String category) {
        return categoryDataChainMap.get(category);
    }
    
    public ConfigurationView getConfigurationView() {
        ConfigurationView view = new ConfigurationView(getConfigurationDescription());

        for ( CategoryDataChain catDataChain : categoryDataChainMap.values() ) {
            Map<String, ConfigurationParameterTaggedValue> data = catDataChain.getConfigurationParameterTaggedValues();
            for ( ConfigurationParameterTaggedValue taggedValue : data.values() ) {
                view.putParameterValue(taggedValue.getParameterPath(), taggedValue.getParameterValue());
            }
        }
        return view;
    }
    
}
