/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.config.CategoryTag;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;

public class CategoryTagTest
extends CcsTestCaseTemplate {
    @Test
    public void testDefaultCategoryTag() throws Exception {
        String inputCategory = "";
        CategoryTag tag = CategoryTag.parseCategoryTagInput((String)inputCategory);
        Assert.assertEquals((Object)"", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsTag(""));
        Assert.assertEquals((long)-1L, (long)tag.getTagVersion("").intValue());
        Assert.assertEquals((long)1L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)":(d)", (Object)tag.toString());
        inputCategory = ":";
        tag = CategoryTag.parseCategoryTagInput((String)inputCategory);
        Assert.assertEquals((Object)"", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsTag(""));
        Assert.assertEquals((long)-1L, (long)tag.getTagVersion("").intValue());
        Assert.assertEquals((long)1L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)":(d)", (Object)tag.toString());
        inputCategory = "catA:";
        tag = CategoryTag.parseCategoryTagInput((String)inputCategory);
        Assert.assertEquals((Object)"catA", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsTag(""));
        Assert.assertEquals((long)-1L, (long)tag.getTagVersion("").intValue());
        Assert.assertEquals((long)1L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)"catA:(d)", (Object)tag.toString());
        inputCategory = "catA:tag1";
        tag = CategoryTag.parseCategoryTagInput((String)inputCategory);
        Assert.assertEquals((Object)"catA", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsTag("tag1"));
        Assert.assertEquals((long)-1L, (long)tag.getTagVersion("tag1").intValue());
        Assert.assertEquals((long)1L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)(inputCategory + "(d)"), (Object)tag.toString());
        inputCategory = "catA:tag1(l)";
        tag = CategoryTag.parseCategoryTagInput((String)inputCategory);
        Assert.assertEquals((Object)"catA", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsTag("tag1"));
        Assert.assertEquals((long)-2L, (long)tag.getTagVersion("tag1").intValue());
        Assert.assertEquals((long)1L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)inputCategory, (Object)tag.toString());
        inputCategory = "catA:tag1(123)|tag2(44)";
        tag = CategoryTag.parseCategoryTagInput((String)inputCategory);
        Assert.assertEquals((Object)"catA", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsTag("tag1"));
        Assert.assertEquals((long)123L, (long)tag.getTagVersion("tag1").intValue());
        Assert.assertTrue((boolean)tag.containsTag("tag2"));
        Assert.assertEquals((long)44L, (long)tag.getTagVersion("tag2").intValue());
        Assert.assertEquals((long)2L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)inputCategory, (Object)tag.toString());
        inputCategory = "catA:tag1(123)|tag2(44)|(d)";
        tag = CategoryTag.parseCategoryTagInput((String)inputCategory);
        Assert.assertEquals((Object)"catA", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsTag("tag1"));
        Assert.assertEquals((long)123L, (long)tag.getTagVersion("tag1").intValue());
        Assert.assertTrue((boolean)tag.containsTag("tag2"));
        Assert.assertEquals((long)44L, (long)tag.getTagVersion("tag2").intValue());
        Assert.assertTrue((boolean)tag.containsTag(""));
        Assert.assertEquals((long)-1L, (long)tag.getTagVersion("").intValue());
        Assert.assertEquals((long)3L, (long)tag.getNumberOfTags());
        Assert.assertEquals((Object)inputCategory, (Object)tag.toString());
        inputCategory = "tagA";
        tag = CategoryTag.parseCategoryTagInput((String)inputCategory);
        Assert.assertEquals((Object)"", (Object)tag.getCategoryName());
        Assert.assertTrue((boolean)tag.containsTag("tagA"));
        Assert.assertEquals((Object)":tagA(d)", (Object)tag.toString());
        try {
            tag = CategoryTag.parseCategoryTagInput((String)"catA:tag1(123)|tag2(44)|tag1(d)");
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testConfigurationDescription() throws Exception {
        String configDescriptionStr = "[:(d)|tag1(d)*,build:defaultInitial(d),catA:(d)|tag2(d)*,catB:defaultInitial(d),timers:defaultInitial(d)]";
        HashSet<String> allCategories = new HashSet<String>();
        allCategories.add("");
        allCategories.add("build");
        allCategories.add("catA");
        allCategories.add("catB");
        allCategories.add("timers");
        ConfigurationInfo.Builder builder = new ConfigurationInfo.Builder();
        ConfigurationInfo ci = builder.updateConfigurationDescription(configDescriptionStr).build();
        ConfigurationDescription cd = ConfigurationDescription.fromConfigurationInfo((ConfigurationInfo)ci, allCategories);
        Assert.assertEquals((Object)configDescriptionStr, (Object)cd.getDescriptionName());
    }
}

