/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.config.BulkChangeComponent;
import org.lsst.ccs.config.BulkSettingException;
import org.lsst.ccs.config.BulkValidationException;
import org.lsst.ccs.config.ConfigurationHandlerSet;
import org.lsst.ccs.config.WriterProvider;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;

public class ConfigurationBulkChangesTest
extends CcsTestCaseTemplate {
    private static final Map<String, BulkChangeComponent> comps = new LinkedHashMap<String, BulkChangeComponent>();
    private static final String tag = "withBulkSetting";
    private ConfigurationHandlerSet chs;
    private final Object[] changesOK = new Object[]{"OK", 3, 8, 6.28};
    private final Object[] changesValNOK = new Object[]{"NOK", 8, 6, 6.28};
    private final Object[] changesSettingMaxNOK = new Object[]{"NOK", 8, 101, 6.28};
    private final Object[] changesSettingMinNOK = new Object[]{"NOK", -10, 60, 6.28};
    private Object[] initVals;

    @Before
    public void initAgents() throws Exception {
        comps.put("main", new BulkChangeComponent());
        comps.put("son1", new BulkChangeComponent());
        comps.put("son2", new BulkChangeComponent());
        this.chs = new ConfigurationHandlerSet();
        for (Map.Entry<String, BulkChangeComponent> entry : comps.entrySet()) {
            this.chs.addConfigurationHandlerForObject(entry.getKey(), (Object)entry.getValue());
        }
        this.chs.initialize(tag);
        this.initVals = comps.get("main").getConfValues();
    }

    @After
    public void shutdownAgents() throws Exception {
        WriterProvider.setInstance(null);
    }

    @Test
    public void testCommitBulkChangesFailsAtValidation() throws Exception {
        this.submitChanges("main", this.changesOK);
        this.submitChanges("son1", this.changesValNOK);
        this.submitChanges("son2", this.changesOK);
        try {
            this.chs.commitBulkChange(null);
            Assert.fail();
        }
        catch (BulkValidationException ex) {
            for (String key : comps.keySet()) {
                Assert.assertEquals((String)("submitted changes should not have been dropped for " + key), (long)4L, (long)this.chs.getSubmittedChangesForComponent(key).size());
            }
            Assert.assertTrue((String)ex.getCause().getMessage(), (boolean)ex.getCause().getMessage().contains("min greater than max"));
        }
        for (String key : comps.keySet()) {
            Assert.assertArrayEquals((String)("values should not have changed for " + key), (Object[])this.initVals, (Object[])comps.get(key).getConfValues());
        }
    }

    @Test
    public void testCommitBulkChangesSucceeds() throws Exception {
        this.submitChanges("son1", this.changesOK);
        this.submitChanges("son2", this.changesOK);
        this.submitChanges("main", this.changesOK);
        this.chs.commitBulkChange(null);
        Assert.assertArrayEquals((String)"changes should have been applied", (Object[])this.changesOK, (Object[])comps.get("main").getConfValues());
        Assert.assertArrayEquals((String)"changes should have been applied", (Object[])this.changesOK, (Object[])comps.get("son1").getConfValues());
        Assert.assertArrayEquals((String)"changes should have been applied", (Object[])this.changesOK, (Object[])comps.get("son2").getConfValues());
        Assert.assertEquals((long)0L, (long)this.chs.getSubmittedChangesForComponent("main").size());
    }

    @Test
    public void testSetSingleParameter() throws Exception {
        this.chs.submitChange("main", "min", (Object)11);
        this.chs.setSingleParameter("main", "max", (Object)13);
        Assert.assertEquals((long)1L, (long)this.chs.getSubmittedChangesForComponent("main").size());
    }

    @Test
    public void testCommitBulkChangesFailsAtBulkSetting() throws Exception {
        this.submitChanges("main", this.changesOK);
        this.submitChanges("son1", this.changesSettingMaxNOK);
        this.submitChanges("son2", this.changesOK);
        try {
            this.chs.commitBulkChange(null);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (BulkSettingException ex) {
            Throwable cause = ex.getCause();
            Assert.assertTrue((boolean)(cause instanceof IllegalArgumentException));
            for (String name : comps.keySet()) {
                Assert.assertEquals((String)"all changes should have been dropped", (long)0L, (long)this.chs.getSubmittedChangesForComponent(name).size());
            }
        }
        Assert.assertArrayEquals((String)"should have been set", (Object[])this.changesOK, (Object[])comps.get("main").getConfValues());
        Assert.assertArrayEquals((String)"nothing should have been changed", (Object[])this.initVals, (Object[])comps.get("son1").getConfValues());
        Assert.assertArrayEquals((String)"nothing should have been changed", (Object[])this.initVals, (Object[])comps.get("son2").getConfValues());
    }

    @Test
    public void testCommitBulkChangesFailsHalfwayAtBulkSetting() throws Exception {
        this.submitChanges("son1", this.changesSettingMinNOK);
        try {
            this.chs.commitBulkChange(null);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (BulkSettingException ex) {
            Throwable cause = ex.getCause();
            Assert.assertTrue((boolean)(cause instanceof IllegalArgumentException));
            Assert.assertTrue((String)cause.getMessage(), (boolean)cause.getMessage().contains("min cannot be negative"));
            Assert.assertEquals((long)0L, (long)this.chs.getSubmittedChangesForComponent("main").size());
        }
        BulkChangeComponent son1 = comps.get("son1");
        Assert.assertEquals((long)0L, (long)son1.getMin());
        Assert.assertEquals((long)60L, (long)son1.getMax());
        Assert.assertEquals((double)3.14, (double)son1.getValue(), (double)0.0);
    }

    @Test
    public void testSpuriousChangeAtValidationStep() throws Exception {
        this.submitChanges("main", this.changesOK);
        this.submitChanges("son1", this.changesOK);
        this.submitChanges("son2", this.changesOK);
        BulkChangeComponent son1 = comps.get("son1");
        son1.setSpuriousValidation(true);
        try {
            this.chs.commitBulkChange(null);
            Assert.fail();
        }
        catch (BulkSettingException ex) {
            for (String key : comps.keySet()) {
                Assert.assertEquals((String)("submitted changes should have been dropped " + key), (long)0L, (long)this.chs.getSubmittedChangesForComponent(key).size());
            }
            Assert.assertTrue((String)ex.getMessage(), (boolean)ex.getMessage().contains("son1/value"));
        }
        Assert.assertArrayEquals((String)"values should not have changed for main", (Object[])this.initVals, (Object[])comps.get("main").getConfValues());
        Assert.assertArrayEquals((String)"1 value should have changed for son1", (Object[])new Object[]{"", 0, 10, 6.28}, (Object[])comps.get("son1").getConfValues());
        Assert.assertArrayEquals((String)"values should not have changed for son2", (Object[])this.initVals, (Object[])comps.get("son2").getConfValues());
    }

    @Test
    public void testSpuriousChangeAtSettingStep() throws Exception {
        this.submitChanges("main", this.changesOK);
        this.submitChanges("son1", this.changesOK);
        this.submitChanges("son2", this.changesOK);
        BulkChangeComponent son1 = comps.get("son1");
        son1.setSpuriousSetting(true);
        try {
            this.chs.commitBulkChange(null);
            Assert.fail();
        }
        catch (BulkSettingException ex) {
            ex.printStackTrace();
            for (String key : comps.keySet()) {
                Assert.assertEquals((String)("submitted changes should have been dropped " + key), (long)0L, (long)this.chs.getSubmittedChangesForComponent(key).size());
            }
            Assert.assertTrue((String)ex.getCause().getMessage(), (boolean)ex.getCause().getMessage().contains("expected"));
        }
        Assert.assertArrayEquals((String)"values should have been correctly applied for main", (Object[])this.changesOK, (Object[])comps.get("main").getConfValues());
        Assert.assertArrayEquals((String)"son1 has spurious changes", (Object[])new Object[]{"", 6, 8, 3.14}, (Object[])comps.get("son1").getConfValues());
        Assert.assertArrayEquals((String)"values should not have changed for son2", (Object[])this.initVals, (Object[])comps.get("son2").getConfValues());
    }

    private void submitChanges(String component, Object[] changes) {
        this.chs.submitChange(component, "info", changes[0]);
        this.chs.submitChange(component, "min", changes[1]);
        this.chs.submitChange(component, "max", changes[2]);
        this.chs.submitChange(component, "value", changes[3]);
    }
}

