/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.PrintWriter;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.config.AnnotatedClass;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationHandlerSet;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.config.ConfigurationWriterProvider;
import org.lsst.ccs.config.LocalConfigurationDAO;
import org.lsst.ccs.config.WriterProvider;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;

public class LoadConfigurationTest
extends CcsTestCaseTemplate {
    private static final String tag = "validationTest";
    private AnnotatedClass ac;
    private String comp = "someName";
    private ConfigurationHandlerSet chs;

    @Before
    public void initAgents() throws Exception {
        WriterProvider.setInstance(null);
        this.chs = new ConfigurationHandlerSet();
        this.ac = new AnnotatedClass();
        this.chs.addConfigurationHandlerForObject(this.comp, (Object)this.ac);
        this.chs.initialize(tag);
    }

    @Test
    public void testLoadConfiguration() throws Exception {
        ConfigurationWriterProvider wp = new ConfigurationWriterProvider(tag);
        PrintWriter pw = wp.getConfigurationWriter("aConfig", "");
        pw.println(this.comp + "/annotatedDouble=6.28");
        pw.println(this.comp + "/annotatedMap=[key1:1,key2:2,key3:3]");
        pw.flush();
        pw.close();
        LocalConfigurationDAO dao = new LocalConfigurationDAO(tag);
        ConfigurationDescription request = new ConfigurationDescription(this.chs.getCategorySet());
        request.putTagForCategory("", "aConfig", Integer.valueOf(-1));
        ConfigurationView cv = dao.loadConfiguration(tag, request);
        this.chs.loadCategories(cv);
        Assert.assertEquals((double)6.28, (double)this.ac.getDouble(), (double)0.01);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("key1", 1);
        map.put("key2", 2);
        map.put("key3", 3);
        Assert.assertEquals(map, this.ac.getMap());
    }
}

