package org.lsst.ccs.config;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import java.io.Serializable;

/**
 * Entries int his table are generated by reading the status bus where subsystem advertise their startup.
 * <P>
 * Though there is a "endTimestamp" it is possible that the end of an execution is "missed" by the system.
 * So finding the configuration at a precise moment in time may be complex.
 * <p>
 *     this can be done either by sorting (should be performed during a day task)
 *     or as a direct operation
 * <P>
 *   in this last case two operations should correlate:
 *   <UL>
 *       <LI> When creating a new entry with same subsystem name
 *       get all entries with same subsystem and where "timenext" is zero.
 *       put the timenext at current value and if "endTimeStampLimit" is max put the current time
 *        <LI> when looking for a precise entry in time.
 *        just operate a comparison between starttime and endTimeLimit
 *
 *   </UL>
 * @ImplNote
 * to harmonize with the common policy of separating active data from data in history there
 * should be two different tables in the database: one for active runs and the other for past runs.
 * @author bamade
 */
// Date: 24/05/12

    @Entity
public class RunHistory  implements Serializable {
    private static final long serialVersionUID = 927127673789827728L;
    @Id
    @GeneratedValue
    private long id ;

    private String subsystemName;

    private String configurationName;

    private String tag ;

    private long startTimestamp ;
    /**
     * used to tell that the <TT>startTimestamp</TT> is not real but was artificially reconstituted
     * (an unlikely event: end message received and start message lost)
     */
    private boolean startGuessed ;

    /**
     * Possible end of task: may be missing due to dysfunctional system.
     * So next occurence with same subsystem will replace by its own time.
     * Defaults to  STILL_VALID
     */
    private long endTimestampLimit = PackCst.STILL_VALID;
    /**
     * used to tall that the <TT>endTimestampLimit</TT> has been artificially set
     * to a value which is different from constant <TT>STILL_VALID</TT> : this
     * may happen when an "end" message is lost.
     */
    private boolean endGuessed ;

    /**
     * startTimestamp of next entry in time with same subsystem.
     * Defaults to zero
     */
    private long timeNext = 0L;

    //todo: add a boolean to tell that it is a runtime change

    private boolean runtimeChange ;


    RunHistory() {}

    public RunHistory(String subsystemName, String configurationName, String tag, long startTimestamp) {
       this(subsystemName, configurationName, tag, startTimestamp, false )  ;
    }

    public RunHistory(String subsystemName, String configurationName, String tag, long startTimestamp, boolean runtimeChange) {
        this.subsystemName = subsystemName;
        this.configurationName = configurationName;
        this.tag = tag;
        this.startTimestamp = startTimestamp;
        this.runtimeChange = runtimeChange ;
    }

    ///////////////////////////// ACCESSORS/MUTATORS

    public long getId() {
        return id;
    }

     void setId(long id) {
        this.id = id;
    }

    public String getSubsystemName() {
        return subsystemName;
    }

     void setSubsystemName(String subsystemName) {
        this.subsystemName = subsystemName;
    }

    public String getConfigurationName() {
        return configurationName;
    }

     void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public String getTag() {
        return tag;
    }

    void setTag(String tag) {
        this.tag = tag;
    }

    public long getStartTimestamp() {
        return startTimestamp;
    }

     void setStartTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public boolean isStartGuessed() {
        return startGuessed;
    }

    public void setStartGuessed(boolean startGuessed) {
        this.startGuessed = startGuessed;
    }

    public boolean isEndGuessed() {
        return endGuessed;
    }

    public void setEndGuessed(boolean endGuessed) {
        this.endGuessed = endGuessed;
    }

    public long getEndTimestampLimit() {
        return endTimestampLimit;
    }

    public void setEndTimestampLimit(long endTimestampLimit) {
        this.endTimestampLimit = endTimestampLimit;
    }

    public long getTimeNext() {
        return timeNext;
    }

    public void setTimeNext(long timeNext) {
        this.timeNext = timeNext;
    }

    public boolean isRuntimeChange() {
        return runtimeChange;
    }

    void setRuntimeChange(boolean runtimeChange) {
        this.runtimeChange = runtimeChange;
    }
}
