package org.lsst.ccs.config;

/**
 * Exception that happens during rollback
 * @author bamade
 */
// Date: 09/12/14

public class RollBackException  extends Exception {
    private String component;
    private String parameter ;
    private String value ;

    public RollBackException(Throwable cause, String component, String parameter, String value) {
        super(cause);
        this.component = component;
        this.parameter = parameter;
        this.value = value;
    }

    public String toString() {
        return super.toString() +
                " -> component: " + component +
                ", parameter: " + parameter +
                ", value: " + value ;
    }
}
