package org.lsst.ccs.config;

import javax.persistence.Embeddable;
import java.io.Serializable;
import static org.lsst.ccs.config.utilities.ConfigUtils.baseNameFromNames;
import static org.lsst.ccs.config.utilities.ConfigUtils.isAPath;

/**
 * A data structure that contains name of subsystem, configuration and tag, and
 * the full path to the configuration file
 * @author bamade
 */
// Date: 12/04/12

    @Embeddable
public  class NamesAndTag implements Serializable {
    private static final long serialVersionUID = -3581991261638846892L;
    public String subsystemName ;
    public String configName ;
    public String tag ;
    public String configPath;


    NamesAndTag() {
    }
    
    public NamesAndTag(String subsystemName, String configName, String tag) {
        this.subsystemName = subsystemName;
        if(configName == null) configName ="" ;
        this.configName = configName;
        if(tag == null) tag ="" ;
        this.tag = tag;
    }
    
    public NamesAndTag(String subsystemName, String configName, String tag, String configPath) {
        this(subsystemName,configName,tag);
        this.setConfigPath(configPath);
    }

    public String getSubsystemName() {
        return subsystemName;
    }

    public void setSubsystemName(String subsystemName) {
        this.subsystemName = subsystemName;
    }

    public String getConfigName() {
        return configName;
    }

    public void setConfigName(String configName) {
        if(configName == null ) configName = "" ;
        this.configName = configName;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        if(tag == null ) tag = "" ;
        this.tag = tag;
    }
    
    private void setConfigPath(String configNameOrPath){
        String realConfigPath = null;
        // Real configuration path reconstruction
        if (isAPath(configNameOrPath)){
            realConfigPath = configNameOrPath;
        } else {
            realConfigPath = baseNameFromNames(subsystemName, configName, tag);
        }
        this.configPath = realConfigPath;
    }
    
    public String getConfigPath(){
        return configPath;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        NamesAndTag that = (NamesAndTag) o;

        if (!configName.equals(that.configName)) return false;
        if (!subsystemName.equals(that.subsystemName)) return false;
        if (!tag.equals(that.tag)) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = subsystemName.hashCode();
        result = 31 * result + configName.hashCode();
        result = 31 * result + tag.hashCode();
        return result;
    }

    public String toString() {
        return subsystemName+'_'+configName+'_'+tag ;
    }
}
