package org.lsst.ccs.config;

import javax.persistence.Entity;
import javax.persistence.Id;
import java.io.Serializable;

/**
 * Describes a Machine Configuration
 */
@Entity
public class MachineConfiguration implements Serializable {
    private static final long serialVersionUID = 6504855068042840898L;
    //TODO: change that so we can only read one table instead of 3

    //public static enum Type {
        /**
         * data is directly in the subsystemDescription table
         */
        //DESCRIPTION,
        /**
         * data is indirectly in description referenced by config profile,
         * corresponding ParameterConfiguration should be merged
         */
        //PROFILE,
        /**
         * data is prepared (in a special table)
         */
        //PREPARED ;
    //}

    @Id
    private String macAddress ;

    //@Enumerated(javax.persistence.EnumType.STRING)
    //private Type type = Type.DESCRIPTION ;

    private String subsystemName ;
    /**
     * means should be updated if subsystem description changes!
     * a special code could do that on request.
     */
    private String configName ;

    private String tag ;


    ///////////////////////// CONSTRUCTORS

    public MachineConfiguration() {
    }

    public MachineConfiguration(String macAddress, String subsystemName, String configName, String tag) {
        this.macAddress = macAddress;
        this.subsystemName = subsystemName;
        this.configName = configName;
        this.tag = tag;
    }
//////////////////////// ACCESSORS/MUTATORS


    public String getMacAddress() {
        return macAddress;
    }

     void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public String getSubsystemName() {
        return subsystemName;
    }

    public void setSubsystemName(String subsystemName) {
        this.subsystemName = subsystemName;
    }

    public String getConfigName() {
        return configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }
}
