package org.lsst.ccs.commons.annotations.scanner;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Map;

/**
 * An interface representing the object with regards to the parameterized
 * annotation {@code T}
 *
 * @author LSST CCS Team
 * @param <T> the annotation class
 */
public interface ReflectObject<T extends Annotation> {
    
    /**
     * Gets the object itself.
     * @return the object
     */
    public Object getTarget();
    
    /**
     * Gets the annotated fields for this object.
     * @return a map of fields to their name.
     */
    public Map<String, Field> getFields();
    
    /**
     * Gets the annotation for the given field name.
     * @param fieldName the field name
     * @return the annotation associated to the field.
     */
    public T getAnnotation(String fieldName);
    
}
