/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.BootstrapUtils;

class ResourcesTreeProperties
extends Properties {
    private static final long serialVersionUID = 7160061705524582442L;
    private final String resourceDirectory;
    private final String propertyFileName;
    private final Properties parent;
    private ResourcesTreeProperties child;
    private static final String prop_str_pattern = ".*(\\$\\[prop\\.(.*)\\]).*";
    private static final Pattern prop_pattern = Pattern.compile(".*(\\$\\[prop\\.(.*)\\]).*");
    private static final Logger LOG = Logger.getLogger(ResourcesTreeProperties.class.getName());

    ResourcesTreeProperties(String propertyFileName, String resourceDirectory, Properties parent) {
        super(parent);
        this.resourceDirectory = resourceDirectory;
        this.propertyFileName = propertyFileName;
        this.parent = parent;
        if (parent != null && parent instanceof ResourcesTreeProperties) {
            ((ResourcesTreeProperties)parent).setChild(this);
        }
    }

    private void setChild(ResourcesTreeProperties child) {
        this.child = child;
    }

    String getResourceDirectory() {
        return this.resourceDirectory;
    }

    String getPropertyFileName() {
        return this.propertyFileName;
    }

    boolean hasParent() {
        return this.parent != null;
    }

    Properties getParent() {
        return this.parent;
    }

    @Override
    public synchronized Object get(Object key) {
        return this.parseGoingOut((String)super.get(key));
    }

    @Override
    public String getProperty(String key) {
        return this.parseGoingOut(super.getProperty(key));
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.parseGoingOut(super.getProperty(key, defaultValue));
    }

    String getPropertyFromTop(String key) {
        if (this.child != null) {
            return this.child.getPropertyFromTop(key);
        }
        return this.getProperty(key);
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        Properties p = new Properties(){

            @Override
            public synchronized Object put(Object key, Object value) {
                if (super.containsKey(key)) {
                    LOG.log(Level.WARNING, "Properties file {0}{1} contains duplicate entry {2}", new Object[]{ResourcesTreeProperties.this.resourceDirectory, ResourcesTreeProperties.this.propertyFileName, key});
                }
                return super.put(key, value);
            }
        };
        try {
            p.load(inStream);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load file: " + this.resourceDirectory + this.propertyFileName, e);
        }
        super.putAll((Map<?, ?>)p);
    }

    @Override
    public synchronized boolean contains(Object value) {
        boolean is = false;
        if (this.parent != null) {
            is = this.parent.contains(value);
        }
        if (is) {
            return is;
        }
        return super.contains(value);
    }

    @Override
    public synchronized boolean containsKey(Object value) {
        boolean is = false;
        if (this.parent != null) {
            is = this.parent.containsKey(value);
        }
        if (is) {
            return is;
        }
        return super.containsKey(value);
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        boolean is = false;
        if (this.parent != null) {
            is = this.parent.containsValue(value);
        }
        if (is) {
            return is;
        }
        return super.containsValue(value);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        String valueStr = BootstrapUtils.parseProperty((String)value);
        return super.put(key, valueStr);
    }

    void copyProperties(Properties props) {
        if (this.parent != null) {
            if (this.parent instanceof ResourcesTreeProperties) {
                ((ResourcesTreeProperties)this.parent).copyProperties(props);
            } else {
                for (Object key : this.parent.keySet()) {
                    props.put(key, this.parent.get(key));
                }
            }
        }
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            props.put(entry.getKey(), entry.getValue());
        }
    }

    private String parseGoingOut(String inputProperty) {
        if (inputProperty == null) {
            return inputProperty;
        }
        String outProperty = inputProperty;
        Matcher m = prop_pattern.matcher(outProperty);
        if (m.matches()) {
            String propValue = this.getPropertyFromTop(m.group(2));
            if (propValue == null) {
                propValue = System.getProperty(m.group(2));
            }
            if (propValue != null) {
                outProperty = outProperty.replace(m.group(1), propValue);
            } else if (Bootstrap.isBootstrapEnvironment()) {
                System.err.println("[WARNING] Property " + m.group(2) + " is not defined.");
            }
        }
        return outProperty;
    }
}

