package org.lsst.ccs.command;

import java.io.Serializable;
import java.util.List;

/**
 * Encapsulate the dictionary information about a single argument.
 * If the parameter is an Enum, we capture the list of legal values (we
 * do not want to require that the Enum class itself be available in a remote 
 * client).
 * @author tonyj
 */
public interface DictionaryArgument extends Serializable {

    String getDescription();

    String getName();

    /**
     * Get the simple type of this parameter
     * @return The simple type (e.g. String)
     */
    String getSimpleType();

    /**
     * Get the type of this parameter
     * @return The full canonical type (e.g. java.lang.String)
     */
    String getType();

    /**
     * Get the list of allowed values for this DictionaryArgument.
     * This list will be used during tab completion.
     * @return The List of allowed values. Empty if no values are available.
     */
    List<String> getAllowedValues();
    
    String getDefaultValue();
    
    default boolean hasDefaultValue() {
        return false;
    }
    
    
}
