package org.lsst.ccs.command;

import java.util.List;

/**
 * An exception thrown when a command Argument does not match the provided values.
 * 
 */
public class CommandArgumentMatchException extends Exception {

    public CommandArgumentMatchException(String message) {
        super(message);
    }
        
    protected static void throwExceptionIfNeeded(List<CommandArgumentMatchException> exceptions) throws CommandArgumentMatchException {
        if (!exceptions.isEmpty()) {
            String message = "";
            for (CommandArgumentMatchException ex : exceptions) {
                if (!message.isEmpty()) {
                    message += "\n";
                }
                message += ex.getMessage();
            }
            throw new CommandArgumentMatchException(message);
        }        
    }
}
