/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import junit.framework.TestCase;
import org.lsst.ccs.command.AmbiguousCommandException;
import org.lsst.ccs.command.CommandDictionaryBuilder;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryUtils;
import org.lsst.ccs.command.demo.AmbiguousCommands;
import org.lsst.ccs.command.demo.DemoCommands;
import org.lsst.ccs.command.demo.RCMReg;

public class DictionaryBuilderTest
extends TestCase {
    public void testCreateCommandDictionary() {
        CommandDictionaryBuilder builder = new CommandDictionaryBuilder(DemoCommands.class);
        Dictionary dict = builder.getCommandDictionary();
        DictionaryBuilderTest.assertEquals((int)9, (int)dict.size());
        DictionaryCommand cd = DictionaryUtils.findCommand((Dictionary)dict, (String)"add", (int)2);
        DictionaryBuilderTest.assertEquals((int)2, (int)cd.getArguments().length);
        DictionaryBuilderTest.assertEquals((String)"add", (String)cd.getCommandName());
        DictionaryBuilderTest.assertEquals((String)"a", (String)cd.getArguments()[0].getName());
        DictionaryBuilderTest.assertEquals((String)"b", (String)cd.getArguments()[1].getName());
        DictionaryBuilderTest.assertEquals((int)0, (int)cd.getLevel());
        DictionaryBuilderTest.assertFalse((boolean)cd.isVarArgs());
        cd = DictionaryUtils.findCommand((Dictionary)dict, (String)"ACrazyLongNameToTestIfHelpFormatingWorks", (int)0);
        DictionaryBuilderTest.assertEquals((int)1, (int)cd.getLevel());
    }

    public void testCreateCommandDictionary2() {
        CommandDictionaryBuilder builder = new CommandDictionaryBuilder(RCMReg.class);
        Dictionary dict = builder.getCommandDictionary();
        DictionaryBuilderTest.assertEquals((int)4, (int)dict.size());
    }

    public void testCommandDictionaryEnum() {
        CommandDictionaryBuilder builder = new CommandDictionaryBuilder(DemoCommands.class);
        Dictionary dict = builder.getCommandDictionary();
        DictionaryCommand dc = DictionaryUtils.findCommand((Dictionary)dict, (String)"dayOfWeek", (int)1);
        DictionaryBuilderTest.assertEquals((String)"dayOfWeek", (String)dc.getCommandName());
        DictionaryBuilderTest.assertEquals((int)1, (int)dc.getArguments().length);
        DictionaryBuilderTest.assertEquals((String)"org.lsst.ccs.command.demo.DemoCommands.Day", (String)dc.getArguments()[0].getType());
        DictionaryBuilderTest.assertEquals((String)"Day", (String)dc.getArguments()[0].getSimpleType());
        DictionaryBuilderTest.assertEquals((int)7, (int)dc.getArguments()[0].getAllowedValues().size());
    }

    public void testCommandDictionaryAlias() {
        CommandDictionaryBuilder builder = new CommandDictionaryBuilder(DemoCommands.class);
        Dictionary dict = builder.getCommandDictionary();
        DictionaryCommand dc = DictionaryUtils.findCommand((Dictionary)dict, (String)"gt", (int)1);
        DictionaryBuilderTest.assertEquals((String)"getTemperature", (String)dc.getCommandName());
        DictionaryBuilderTest.assertEquals((int)1, (int)dc.getArguments().length);
    }

    public void testCommandDictionaryAlias2() {
        CommandDictionaryBuilder builder = new CommandDictionaryBuilder(DemoCommands.class);
        Dictionary dict = builder.getCommandDictionary();
        DictionaryCommand dc = DictionaryUtils.findCommand((Dictionary)dict, (String)"day", (int)1);
        DictionaryBuilderTest.assertEquals((String)"dayOfWeek", (String)dc.getCommandName());
        DictionaryBuilderTest.assertEquals((int)1, (int)dc.getArguments().length);
        DictionaryBuilderTest.assertEquals((String)"org.lsst.ccs.command.demo.DemoCommands.Day", (String)dc.getArguments()[0].getType());
        DictionaryBuilderTest.assertEquals((String)"Day", (String)dc.getArguments()[0].getSimpleType());
        DictionaryBuilderTest.assertEquals((int)7, (int)dc.getArguments()[0].getAllowedValues().size());
    }

    public void testDefaultParameterNames() throws Exception {
        DictionaryBuilderTest.assertEquals((String)DemoCommands.class.getMethod("getTemperature", Integer.TYPE).getParameters()[0].getName(), (String)"module");
    }

    public void testAmbiguousCommands() {
        try {
            new CommandDictionaryBuilder(AmbiguousCommands.class);
            DictionaryBuilderTest.fail((String)"Ambiguous command should have thrown an exception");
        }
        catch (RuntimeException runtimeException) {}
    }

    public void testAmbiguousCommandsWhenAddingCommandCompositeSets() {
        CommandSetBuilder builder = new CommandSetBuilder();
        CompositeCommandSet compositeSet = new CompositeCommandSet();
        compositeSet.add(builder.buildCommandSet((Object)new DemoCommands()));
        try {
            compositeSet.add(builder.buildCommandSet((Object)new DemoCommands()));
        }
        catch (AmbiguousCommandException ambiguousCommandException) {
            return;
        }
        DictionaryBuilderTest.assertTrue((boolean)false);
    }

    public void testCommandsWithDefaults() {
        CommandDictionaryBuilder builder = new CommandDictionaryBuilder(DemoCommands.class);
        Dictionary dict = builder.getCommandDictionary();
        DictionaryCommand dc = DictionaryUtils.findCommand((Dictionary)dict, (String)"zcommandWithDefault", (int)1);
        DictionaryBuilderTest.assertEquals((String)"zcommandWithDefault", (String)dc.getCommandName());
        DictionaryCommand dc1 = DictionaryUtils.findCommand((Dictionary)dict, (String)"zcommandWithDefault", (int)0);
        DictionaryBuilderTest.assertEquals((String)"zcommandWithDefault", (String)dc1.getCommandName());
        DictionaryCommand dc2 = DictionaryUtils.findCommand((Dictionary)dict, (String)"zcommandWithEmptyDefault", (int)0);
        DictionaryBuilderTest.assertNull((Object)dc2);
        DictionaryCommand dc3 = DictionaryUtils.findCommand((Dictionary)dict, (String)"zcommandWithEmptyDefault", (int)1);
        DictionaryBuilderTest.assertEquals((String)"zcommandWithEmptyDefault", (String)dc3.getCommandName());
        DictionaryUtils.findCommand((Dictionary)dict, (String)"zcommandWithEmptyDefault", (int)4);
        DictionaryBuilderTest.assertEquals((String)"zcommandWithEmptyDefault", (String)dc3.getCommandName());
    }
}

