/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command.demo.subsystem;

import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.RouteSelectionCommandSet;
import org.lsst.ccs.command.RoutingCommandSet;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.command.demo.remote.jgroups.JGroupsCommandServer;
import org.lsst.ccs.command.demo.subsystem.ModuleA;
import org.lsst.ccs.command.demo.subsystem.ModuleB;

public class Subsystem {
    private final String subsystemName;
    private final ModuleA a;
    private final ModuleB b;

    public Subsystem(String name) {
        this.subsystemName = name;
        this.a = new ModuleA();
        this.b = new ModuleB();
    }

    @Command(description="Return the subsystem name")
    public String showName() {
        return this.subsystemName;
    }

    public static void main(String[] args) throws Exception {
        Subsystem s = new Subsystem("Test");
        CompositeCommandSet cs = s.createCommandSet();
        JGroupsCommandServer server = new JGroupsCommandServer((CommandSet)cs);
    }

    public CompositeCommandSet createCommandSet() {
        CommandSetBuilder builder = new CommandSetBuilder();
        RoutingCommandSet rcsA = new RoutingCommandSet("A", builder.buildCommandSet((Object)this.a));
        RoutingCommandSet rcsB = new RoutingCommandSet("B", builder.buildCommandSet((Object)this.b));
        CompositeCommandSet cs = new CompositeCommandSet();
        cs.add(builder.buildCommandSet((Object)this));
        cs.add((CommandSet)rcsB);
        cs.add((CommandSet)rcsA);
        RouteSelectionCommandSet rs_cs = new RouteSelectionCommandSet(cs);
        return rs_cs;
    }
}

