/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.data.AdditionalFile;
import org.lsst.ccs.subsystem.imagehandling.data.JsonFile;
import org.lsst.ccs.subsystem.imagehandling.data.MeasuredShutterTime;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSAdditionalFileEvent;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterInterface;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterMotionProfileFitter;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterMotionProfileSender;
import org.lsst.ccs.subsystem.ocsbridge.states.ShutterReadinessState;
import org.lsst.ccs.subsystem.ocsbridge.states.ShutterState;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class ShutterSimulation
implements ShutterInterface {
    private static final Logger LOG = Logger.getLogger(ShutterSimulation.class.getName());
    private final CCS ccs;
    private final State shutterState;
    private final MCMConfig config;
    private ScheduledFuture<?> notReadyFuture;
    private boolean imageSequence = false;
    static final Duration READY_TIME = Duration.ofMillis(4000L);
    static final Duration READY_TIME_FOR_SEVERAL_IMAGES = Duration.ofMillis(10000L);
    private ImageName currentImageName;
    private long currentOpenTime;

    ShutterSimulation(CCS ccs, State shutterState, MCMConfig config) {
        this.ccs = ccs;
        this.shutterState = shutterState;
        this.config = config;
        if (config.getShutterPrepTime() > 0.0) {
            shutterState.addStateChangeListener((when, state, oldState, cause) -> {
                if (state == ShutterState.CLOSED) {
                    this.scheduleNotReady();
                } else {
                    this.cancelNotReady();
                }
            });
        }
    }

    @Override
    public void start(String configName) throws ExecutionException {
    }

    @Override
    public void expose(ImageName imageName, Duration exposureTime) throws ExecutionException {
        try {
            this.shutterState.checkState(new Enum[]{ShutterState.CLOSED});
            this.shutterState.setState(ShutterState.OPENING);
            ScheduledFuture<?> stateOpen = this.ccs.schedule(Shutter.MOVE_TIME, () -> this.shutterState.setState(ShutterState.OPEN));
            stateOpen.get();
            this.sendMotionProfile(imageName, "maincamera/shutter1-MotionDone-64.ser", true);
            this.ccs.schedule(exposureTime.minus(Shutter.MOVE_TIME), () -> this.shutterState.setState(ShutterState.CLOSING));
            ScheduledFuture<?> stateClosed = this.ccs.schedule(exposureTime, () -> this.shutterState.setState(ShutterState.CLOSED));
            stateClosed.get();
            this.sendMotionProfile(imageName, "maincamera/shutter1-MotionDone-89.ser", false);
            this.sendMeasuredShutterTime(imageName, (double)exposureTime.getSeconds() + 0.1);
        }
        catch (InterruptedException x) {
            throw new ExecutionException("Unexpected interrupt during shutter expose", x);
        }
    }

    private void sendMeasuredShutterTime(ImageName imageName, double measuredShutterOpenTime) {
        if (this.config.getCameraType() == Camera.MAIN_CAMERA && imageName != null) {
            this.ccs.schedule(Duration.ofMillis(300L), () -> {
                MeasuredShutterTime mst = new MeasuredShutterTime(imageName, measuredShutterOpenTime);
                KeyValueData kvd = new KeyValueData("CCSMeasuredShutterTime", (Serializable)mst);
                StatusSubsystemData ssd = new StatusSubsystemData(kvd);
                LOG.log(Level.INFO, "Sending {0}", mst);
                this.ccs.fireEvent((StatusMessage)ssd);
            });
        }
    }

    private void sendMotionProfile(ImageName imageName, String file, boolean isOpen) {
        if (this.config.getCameraType() == Camera.MAIN_CAMERA && imageName != null) {
            try {
                MotionDone motionDone = ShutterSimulation.readMotionDone(file);
                CompletableFuture<ShutterMotionProfileFitter> futureFit = ShutterMotionProfileFitter.fit(this.ccs.getScheduler(), motionDone);
                futureFit.thenApply(fitResult -> {
                    ShutterMotionProfileSender motionProfileSender = new ShutterMotionProfileSender(imageName, motionDone, isOpen, (ShutterMotionProfileFitter)fitResult);
                    JsonFile jsonProfileOpen = motionProfileSender.getJsonFile();
                    LOG.log(Level.INFO, "Sending {0}", jsonProfileOpen.getFileName());
                    this.ccs.fireEvent(new CCSAdditionalFileEvent((AdditionalFile)jsonProfileOpen));
                    return null;
                });
            }
            catch (IOException | ClassNotFoundException | EmbeddedObjectDeserializationException io) {
                LOG.log(Level.SEVERE, "Could not send motion profile event", io);
            }
        }
    }

    @Override
    public void open(ImageName imageName) throws ExecutionException {
        this.currentImageName = imageName;
        this.currentOpenTime = System.currentTimeMillis();
        this.shutterState.setState(ShutterState.OPENING);
        this.ccs.schedule(Shutter.MOVE_TIME, () -> this.shutterState.setState(ShutterState.OPEN));
    }

    @Override
    public void close() throws ExecutionException {
        this.shutterState.setState(ShutterState.CLOSING);
        this.ccs.schedule(Shutter.MOVE_TIME, () -> this.shutterState.setState(ShutterState.CLOSED));
        this.sendMeasuredShutterTime(this.currentImageName, (double)(System.currentTimeMillis() - this.currentOpenTime) / 1000.0);
    }

    @Override
    public void prepare() {
        if (this.config.getShutterPrepTime() > 0.0) {
            this.cancelNotReady();
            this.ccs.getAggregateStatus().add(CCSTimeStamp.currentTime(), new State<ShutterReadinessState>(ShutterReadinessState.GETTING_READY));
            this.ccs.schedule(Duration.ofMillis((long)(this.config.getShutterPrepTime() * 1000.0)), () -> {
                this.ccs.getAggregateStatus().add(CCSTimeStamp.currentTime(), new State<ShutterReadinessState>(ShutterReadinessState.READY));
                this.scheduleNotReady();
            });
        }
    }

    private void scheduleNotReady() {
        Duration ready_time = this.imageSequence ? READY_TIME_FOR_SEVERAL_IMAGES : READY_TIME;
        this.notReadyFuture = this.ccs.schedule(ready_time, () -> this.ccs.getAggregateStatus().add(CCSTimeStamp.currentTime(), new State<ShutterReadinessState>(ShutterReadinessState.NOT_READY)));
    }

    private void cancelNotReady() {
        if (this.notReadyFuture != null) {
            this.notReadyFuture.cancel(false);
        }
    }

    @Override
    public void setImageSequence(boolean imageSequence) {
        this.imageSequence = imageSequence;
    }

    public static MotionDone readMotionDone(String path) throws IOException, ClassNotFoundException {
        try (InputStream in = ShutterMotionProfileSender.class.getResourceAsStream(path);){
            MotionDone motionDone;
            if (in == null) {
                throw new IOException("Could not open motion profile from " + path);
            }
            try (ObjectInputStream ois = new ObjectInputStream(in);){
                StatusSubsystemData ssd = (StatusSubsystemData)ois.readObject();
                KeyValueData subsystemData = ssd.getSubsystemData();
                motionDone = (MotionDone)subsystemData.getValue();
            }
            return motionDone;
        }
    }
}

