/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.freehep.application.Application;
import org.freehep.application.PrintHelper;
import org.freehep.application.PrintOptions;
import org.freehep.application.studio.Studio;

class PrintDialog
extends JOptionPane {
    private JButton cancel = new JButton("Cancel");
    private JButton page = new JButton("Page Setup...");
    private JButton preview = new JButton("Print Preview...");
    private JButton ok = new JButton("OK");
    private JButton setup = new JButton("Printer Setup...");
    private JDialog dlg;
    private PrintHelper printable;
    private ActionListener al = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Object source = e.getSource();
                if (source == PrintDialog.this.ok) {
                    PrintDialog.this.setValue(source);
                } else if (source == PrintDialog.this.cancel) {
                    PrintDialog.this.setValue(source);
                } else if (source == PrintDialog.this.page) {
                    PrintDialog.this.printable.pageDialog(PrintDialog.this);
                } else if (source == PrintDialog.this.setup) {
                    PrintDialog.this.printable.printDialog(PrintDialog.this);
                } else if (source == PrintDialog.this.preview) {
                    PrintDialog.this.printable.printPreview(PrintDialog.this);
                } else {
                    PrintDialog.this.enableButtons();
                }
            }
            catch (PrinterException x) {
                Application.error(PrintDialog.this, "Print Error", x);
            }
        }
    };

    PrintDialog(Studio app, PrintHelper printable) {
        this.printable = printable;
        PrintOptions xx = new PrintOptions(printable);
        this.setMessage(xx);
        Object[] buttons = new JButton[]{this.ok, this.preview, this.setup, this.page, this.cancel};
        this.setOptions(buttons);
        for (int i = 0; i < buttons.length; ++i) {
            ((AbstractButton)buttons[i]).addActionListener(this.al);
        }
        this.enableButtons();
    }

    int showDialog(Component parent) {
        this.dlg = this.createDialog(parent, "Plot Page Print Setup");
        this.dlg.setVisible(true);
        if (this.value == null) {
            return -1;
        }
        if (this.value == this.ok) {
            return 0;
        }
        return 2;
    }

    private void enableButtons() {
    }
}

