/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.utilities;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lsst.ccs.Agent;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.daq.utilities.FitsServiceConfiguration;
import org.lsst.ccs.daq.utilities.FitsServiceInterface;
import org.lsst.ccs.daq.utilities.PerRebFitsService;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentStatusAggregatorService;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.location.Location;

public class FitsService
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final Map<String, FitsServiceConfiguration> configs = new LinkedHashMap<String, FitsServiceConfiguration>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStatusAggregatorService aggregatorService;
    private final Map<Location, PerRebFitsService> perRebFitsServices = new ConcurrentHashMap<Location, PerRebFitsService>();
    private final Map<Reb, String> rebs = new HashMap<Reb, String>();
    private boolean hasBeenStarted = false;

    public void start() {
        for (Map.Entry<Reb, String> reb : this.rebs.entrySet()) {
            this.createPerRebFitsService(reb.getKey(), reb.getValue());
        }
        this.hasBeenStarted = true;
    }

    public void addReb(Reb reb, String configName) {
        this.rebs.put(reb, configName);
        if (this.hasBeenStarted) {
            this.createPerRebFitsService(reb, configName);
        }
    }

    public void clearAllRebs() {
        this.perRebFitsServices.clear();
        this.rebs.clear();
    }

    public FitsServiceInterface getFitsServiceForReb(Reb reb) {
        return this.perRebFitsServices.get(reb.getLocation());
    }

    public Map<String, HeaderSpecification> getHeaderSpecificationMap(String configName) {
        return this.getConfigurationByName(configName).getHeaderSpecificationMap();
    }

    private FitsServiceConfiguration getConfigurationByName(String configName) {
        FitsServiceConfiguration config = this.configs.get(configName);
        if (config == null) {
            throw new RuntimeException("Unknown config name " + configName);
        }
        return config;
    }

    private void createPerRebFitsService(Reb reb, String configName) {
        PerRebFitsService perRebFitsService = new PerRebFitsService(this.agent.getName(), this.aggregatorService, this.getConfigurationByName(configName).getHeaderSpecificationMap(), reb);
        this.perRebFitsServices.put(reb.getLocation(), perRebFitsService);
    }
}

