/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandArgumentTypeException;
import org.lsst.ccs.command.CommandDictionaryBuilder;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.Options;
import org.lsst.ccs.command.SupportedOption;
import org.lsst.ccs.command.TokenizedCommand;
import org.lsst.ccs.utilities.conv.InputConversionEngine;
import org.lsst.ccs.utilities.conv.TypeConversionException;

public class RawCommand
implements BasicCommand {
    private final String commandName;
    private final List<Object> arguments;
    private Options options = new Options();
    private static final long serialVersionUID = 8273895275408621472L;

    public RawCommand(String commandName, List<Object> arguments) {
        Map<Boolean, List<Object>> m = arguments.stream().collect(Collectors.partitioningBy(a -> a instanceof Options));
        List<Object> listOfOptions = m.get(true);
        if (listOfOptions.isEmpty()) {
            this.arguments = arguments;
            this.options = new Options();
        } else {
            if (listOfOptions.size() > 1) {
                throw new IllegalArgumentException("The list of command arguments cannot contain more than one instance of Options");
            }
            this.arguments = m.get(false);
            this.options = (Options)listOfOptions.get(0);
        }
        this.commandName = commandName;
    }

    public RawCommand(String commandName, List<Object> arguments, Options options) {
        this.commandName = commandName;
        this.arguments = arguments;
        this.options = options;
    }

    @Override
    public String getCommand() {
        return this.commandName;
    }

    @Override
    public Object getArgument(int index) {
        return this.arguments.get(index);
    }

    @Override
    public Object[] getArguments() {
        return this.arguments.toArray();
    }

    @Override
    public int getArgumentCount() {
        return this.arguments.size();
    }

    @Override
    public Options getOptions() {
        if (this.options == null) {
            return new Options();
        }
        return this.options;
    }

    static RawCommand toRawCommand(BasicCommand command, Method method, InputConversionEngine engine) throws CommandArgumentTypeException {
        if (command instanceof RawCommand) {
            return (RawCommand)command;
        }
        if (command instanceof TokenizedCommand) {
            try {
                return RawCommand.convertToRaw((TokenizedCommand)command, method, engine);
            }
            catch (TypeConversionException ex) {
                throw new CommandArgumentTypeException(ex.getMessage(), (Exception)((Object)ex));
            }
        }
        throw new IllegalArgumentException("Error: Unknown type of command " + command.getClass().getName());
    }

    private static RawCommand convertToRaw(TokenizedCommand tokenizedCommand, Method method, InputConversionEngine engine) throws TypeConversionException {
        DictionaryCommand methodCommand = CommandDictionaryBuilder.getDictionaryCommandFromMethod(method);
        Type[] allParameterTypes = method.getGenericParameterTypes();
        ArrayList<Type> argTypesNoOptions = new ArrayList<Type>();
        for (Type t : allParameterTypes) {
            if (t == Options.class) continue;
            argTypesNoOptions.add(t);
        }
        Type[] parameterTypes = argTypesNoOptions.toArray(new Type[argTypesNoOptions.size()]);
        ArrayList<Object> args = new ArrayList<Object>(parameterTypes.length);
        boolean varArgs = method.isVarArgs();
        if (varArgs) {
            for (int i = 0; i < parameterTypes.length - 1; ++i) {
                args.add(InputConversionEngine.convertArgToType((String)tokenizedCommand.getArgument(i), (Type)parameterTypes[i]));
            }
            Type varClass = parameterTypes[parameterTypes.length - 1];
            Class<?> elemClass = ((Class)varClass).getComponentType();
            Object theArray = Array.newInstance(elemClass, tokenizedCommand.getArgumentCount() - parameterTypes.length + 1);
            for (int j = 0; j < Array.getLength(theArray); ++j) {
                Array.set(theArray, j, InputConversionEngine.convertArgToType((String)tokenizedCommand.getArgument(parameterTypes.length - 1 + j), elemClass));
            }
            args.add(theArray);
        } else {
            int i;
            int maxArgs = Math.max(parameterTypes.length, tokenizedCommand.getArgumentCount());
            int minArgs = Math.min(parameterTypes.length, tokenizedCommand.getArgumentCount());
            for (i = 0; i < minArgs; ++i) {
                args.add(InputConversionEngine.convertArgToType((String)tokenizedCommand.getArgument(i), (Type)parameterTypes[i]));
            }
            if (tokenizedCommand.getArgumentCount() < parameterTypes.length) {
                for (i = minArgs; i < maxArgs; ++i) {
                    args.add(InputConversionEngine.convertArgToType((String)methodCommand.getArguments()[i].getDefaultValue(), (Type)parameterTypes[i]));
                }
            }
        }
        Options opts = new Options();
        if (methodCommand.hasOptions()) {
            for (String opt : tokenizedCommand.getOptions().getOptions()) {
                boolean isOptionSupported = false;
                boolean isShortOption = opt.length() == 1;
                for (SupportedOption so : methodCommand.getSupportedOptions()) {
                    isOptionSupported = isShortOption ? so.getSingleLetterName().equals(opt) : so.getName().equals(opt);
                    if (!isOptionSupported) continue;
                    opts.withOption(so.getName());
                    break;
                }
                if (isOptionSupported) continue;
                throw new TypeConversionException("Option " + opt + " is not one of the supported options: " + methodCommand.getSupportedOptions(), new Object[0]);
            }
        } else if (tokenizedCommand.getOptions().hasOptions()) {
            throw new TypeConversionException("Options cannot be provided to a command that does not support them.", new Object[0]);
        }
        return new RawCommand(tokenizedCommand.getCommand(), args, opts);
    }

    public String toString() {
        return this.prettyToString();
    }
}

