/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Emulator;
import org.lsst.ccs.daq.ims.Folder;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.Playlist;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.subsystem.focalplane.CCSImageList;
import org.lsst.ccs.subsystem.focalplane.CCSPlayList;
import org.lsst.ccs.utilities.location.LocationSet;

public class CCSEmulatedPlayList
extends CCSPlayList {
    private static final Logger LOG = Logger.getLogger(CCSEmulatedPlayList.class.getName());
    private final Emulator emulator;
    private final Path tempFile;
    private final Store store;
    private final Folder folder;

    CCSEmulatedPlayList(CCSImageList imageList, boolean repeat, Store store) throws DAQException, IOException {
        super(imageList, repeat);
        this.store = store;
        this.emulator = store.getEmulator();
        this.folder = store.getCatalog().find(imageList.getDAQFolder());
        this.tempFile = Files.createTempFile("play", "list", new FileAttribute[0]);
    }

    @Override
    void validate() throws DAQException, CCSPlayList.PlayListException {
        for (String imageName : this.getImageList()) {
            Image currentImage = this.folder.find(imageName);
            if (currentImage != null) continue;
            throw new CCSPlayList.PlayListException("Playlist error, image " + imageName + " does not exist in folder " + this.folder.getName());
        }
    }

    @Override
    void play(String emulatedImageName, String triggeredImageName, LocationSet effectiveLocations, int opCode, String annotation) throws DAQException, IOException, CCSPlayList.PlayListException {
        Files.deleteIfExists(this.tempFile);
        try (Playlist oneImagePlaylist = this.emulator.openPlaylist(this.tempFile.toFile());){
            Image currentImage = this.folder.find(emulatedImageName);
            if (currentImage == null) {
                throw new CCSPlayList.PlayListException("Playlist error, image " + emulatedImageName + " does not exist in folder " + this.folder.getName());
            }
            LOG.log(Level.INFO, "Created temp playlist {0} with image {1}", new Object[]{this.tempFile, currentImage.getMetaData().getName()});
            oneImagePlaylist.add(currentImage);
            List images = oneImagePlaylist.getImages();
            LOG.log(Level.INFO, "Starting temp playlist {0} with image list {1}", new Object[]{this.tempFile, images});
            oneImagePlaylist.start(false);
            LOG.log(Level.INFO, "Started temp playlist {0} with image list {1}", new Object[]{this.tempFile, images});
        }
    }
}

