/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.hub;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.RegInfo;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.client.AbstractMessageHandler;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.httpd.UtilServer;
import org.astrogrid.samp.hub.BasicClientSet;
import org.astrogrid.samp.hub.ClientSet;
import org.astrogrid.samp.hub.HubCallableClient;
import org.astrogrid.samp.hub.HubClient;
import org.astrogrid.samp.hub.HubService;
import org.astrogrid.samp.hub.KeyGenerator;
import org.astrogrid.samp.hub.MessageRestriction;
import org.astrogrid.samp.hub.MetaQueryMessageHandler;
import org.astrogrid.samp.hub.PingMessageHandler;
import org.astrogrid.samp.hub.ProfileToken;

public class BasicHubService
implements HubService {
    private final KeyGenerator keyGen_;
    private final ClientIdGenerator idGen_;
    private final Map waiterMap_;
    private ClientSet clientSet_;
    private HubClient serviceClient_;
    private HubConnection serviceClientConnection_;
    private volatile boolean started_;
    private volatile boolean shutdown_;
    private static final char ID_DELIMITER = '_';
    private final Logger logger_ = Logger.getLogger(BasicHubService.class.getName());
    private static final ProfileToken INTERNAL_PROFILE;
    public static int MAX_TIMEOUT;
    public static int MAX_WAITERS;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BasicHubService(Random random) {
        this.keyGen_ = new KeyGenerator("m:", 16, random);
        this.idGen_ = new ClientIdGenerator("c");
        this.waiterMap_ = Collections.synchronizedMap(new HashMap());
    }

    public void start() {
        this.clientSet_ = this.createClientSet();
        this.serviceClient_ = this.createClient("hub", INTERNAL_PROFILE);
        this.serviceClientConnection_ = this.createConnection(this.serviceClient_);
        Metadata meta = new Metadata();
        meta.setName("Hub");
        try {
            meta.setIconUrl(UtilServer.getInstance().exportResource("/org/astrogrid/samp/images/hub.png").toString());
        }
        catch (Throwable e) {
            this.logger_.warning("Can't set icon");
        }
        meta.put("author.name", "Mark Taylor");
        meta.put("author.mail", "m.b.taylor@bristol.ac.uk");
        meta.setDescriptionText(this.getClass().getName());
        this.serviceClient_.setMetadata(meta);
        HubCallableClient hubCallable = new HubCallableClient(this.serviceClientConnection_, this.createHubMessageHandlers());
        this.serviceClient_.setCallable(hubCallable);
        this.serviceClient_.setSubscriptions(hubCallable.getSubscriptions());
        this.clientSet_.add(this.serviceClient_);
        this.started_ = true;
    }

    protected ClientSet createClientSet() {
        return new BasicClientSet(this.getIdComparator()){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void add(HubClient client) {
                if (!$assertionsDisabled && client.getId().indexOf(95) >= 0) {
                    throw new AssertionError();
                }
                super.add(client);
            }

            static {
                $assertionsDisabled = !(class$org$astrogrid$samp$hub$BasicHubService == null ? (class$org$astrogrid$samp$hub$BasicHubService = BasicHubService.class$("org.astrogrid.samp.hub.BasicHubService")) : class$org$astrogrid$samp$hub$BasicHubService).desiredAssertionStatus();
            }
        };
    }

    protected HubClient createClient(String publicId, ProfileToken ptoken) {
        return new HubClient(publicId, ptoken);
    }

    protected AbstractMessageHandler[] createHubMessageHandlers() {
        return new AbstractMessageHandler[]{new PingMessageHandler(), new MetaQueryMessageHandler(this.getClientSet())};
    }

    public Comparator getIdComparator() {
        return this.idGen_.getComparator();
    }

    public ClientSet getClientSet() {
        return this.clientSet_;
    }

    public HubConnection register(ProfileToken ptoken) throws SampException {
        if (!this.started_) {
            throw new SampException("Not started");
        }
        HubClient client = this.createClient(this.idGen_.next(), ptoken);
        if (!$assertionsDisabled && client.getId().indexOf(95) >= 0) {
            throw new AssertionError();
        }
        this.clientSet_.add(client);
        this.hubEvent(new Message("samp.hub.event.register").addParam("id", client.getId()));
        return this.createConnection(client);
    }

    public void disconnectAll(ProfileToken profileToken) {
        HubClient[] clients = this.clientSet_.getClients();
        ArrayList<String> profClientIdList = new ArrayList<String>();
        for (int ic = 0; ic < clients.length; ++ic) {
            HubClient client = clients[ic];
            if (!profileToken.equals(client.getProfileToken())) continue;
            profClientIdList.add(client.getId());
        }
        this.disconnect(profClientIdList.toArray(new String[0]), new Message("samp.hub.event.shutdown"));
    }

    protected HubConnection createConnection(final HubClient caller) {
        final BasicHubService service = this;
        final RegInfo regInfo = new RegInfo();
        regInfo.put("samp.hub-id", this.serviceClient_.getId());
        regInfo.put("samp.self-id", caller.getId());
        return new HubConnection(){

            public RegInfo getRegInfo() {
                return regInfo;
            }

            public void ping() throws SampException {
                if (!service.isHubRunning()) {
                    throw new SampException("Service is stopped");
                }
            }

            public void unregister() throws SampException {
                this.checkCaller();
                service.unregister(caller);
            }

            public void setCallable(CallableClient callable) throws SampException {
                this.checkCaller();
                service.setCallable(caller, callable);
            }

            public void declareMetadata(Map meta) throws SampException {
                this.checkCaller();
                service.declareMetadata(caller, meta);
            }

            public Metadata getMetadata(String clientId) throws SampException {
                this.checkCaller();
                return service.getMetadata(caller, clientId);
            }

            public void declareSubscriptions(Map subs) throws SampException {
                this.checkCaller();
                service.declareSubscriptions(caller, subs);
            }

            public Subscriptions getSubscriptions(String clientId) throws SampException {
                this.checkCaller();
                return service.getSubscriptions(caller, clientId);
            }

            public String[] getRegisteredClients() throws SampException {
                this.checkCaller();
                return service.getRegisteredClients(caller);
            }

            public Map getSubscribedClients(String mtype) throws SampException {
                this.checkCaller();
                return service.getSubscribedClients(caller, mtype);
            }

            public void notify(String recipientId, Map message) throws SampException {
                this.checkCaller();
                service.notify(caller, recipientId, message);
            }

            public String call(String recipientId, String msgTag, Map message) throws SampException {
                this.checkCaller();
                return service.call(caller, recipientId, msgTag, message);
            }

            public List notifyAll(Map message) throws SampException {
                this.checkCaller();
                return service.notifyAll(caller, message);
            }

            public Map callAll(String msgTag, Map message) throws SampException {
                this.checkCaller();
                return service.callAll(caller, msgTag, message);
            }

            public void reply(String msgId, Map response) throws SampException {
                this.checkCaller();
                service.reply(caller, msgId, response);
            }

            public Response callAndWait(String recipientId, Map message, int timeout) throws SampException {
                this.checkCaller();
                return service.callAndWait(caller, recipientId, message, timeout);
            }

            private void checkCaller() throws SampException {
                if (!BasicHubService.this.clientSet_.containsClient(caller)) {
                    throw new SampException("Client not registered");
                }
            }
        };
    }

    protected void unregister(HubClient caller) throws SampException {
        this.clientSet_.remove(caller);
        this.hubEvent(new Message("samp.hub.event.unregister").addParam("id", caller.getId()));
    }

    protected void setCallable(HubClient caller, CallableClient callable) throws SampException {
        caller.setCallable(callable);
    }

    protected void declareMetadata(HubClient caller, Map meta) throws SampException {
        Metadata.asMetadata(meta).check();
        caller.setMetadata(meta);
        this.hubEvent(new Message("samp.hub.event.metadata").addParam("id", caller.getId()).addParam("metadata", meta));
    }

    protected Metadata getMetadata(HubClient caller, String clientId) throws SampException {
        return this.getClient(clientId).getMetadata();
    }

    protected void declareSubscriptions(HubClient caller, Map subscriptions) throws SampException {
        if (!caller.isCallable()) {
            throw new SampException("Client is not callable");
        }
        Subscriptions subs = Subscriptions.asSubscriptions(subscriptions);
        subs.check();
        caller.setSubscriptions(subs);
        String callerId = caller.getId();
        String serviceId = this.serviceClient_.getId();
        String mtype = "samp.hub.event.subscriptions";
        HubClient[] recipients = this.clientSet_.getClients();
        for (int ic = 0; ic < recipients.length; ++ic) {
            HubClient recipient = recipients[ic];
            if (recipient == this.serviceClient_ || !this.canSend(this.serviceClient_, recipient, mtype) || !this.clientSet_.containsClient(recipient)) continue;
            Message msg = new Message(mtype);
            msg.addParam("id", callerId);
            msg.addParam("subscriptions", this.getSubscriptionsFor(recipient, subs));
            try {
                recipient.getCallable().receiveNotification(serviceId, msg);
                continue;
            }
            catch (Exception e) {
                this.logger_.log(Level.WARNING, "Notification " + caller + " -> " + recipient + " failed: " + e, e);
            }
        }
    }

    protected Subscriptions getSubscriptions(HubClient caller, String clientId) throws SampException {
        return this.getSubscriptionsFor(caller, this.getClient(clientId).getSubscriptions());
    }

    protected String[] getRegisteredClients(HubClient caller) throws SampException {
        HubClient[] clients = this.clientSet_.getClients();
        ArrayList<String> idList = new ArrayList<String>(clients.length);
        for (int ic = 0; ic < clients.length; ++ic) {
            if (clients[ic].equals(caller)) continue;
            idList.add(clients[ic].getId());
        }
        return idList.toArray(new String[0]);
    }

    protected Map getSubscribedClients(HubClient caller, String mtype) throws SampException {
        HubClient[] clients = this.clientSet_.getClients();
        TreeMap<String, Map> subMap = new TreeMap<String, Map>();
        for (int ic = 0; ic < clients.length; ++ic) {
            Map sub;
            HubClient client = clients[ic];
            if (client.equals(caller) || (sub = client.getSubscriptions().getSubscription(mtype)) == null || !this.canSend(caller, client, mtype)) continue;
            subMap.put(client.getId(), sub);
        }
        return subMap;
    }

    protected void notify(HubClient caller, String recipientId, Map message) throws SampException {
        Message msg = Message.asMessage(message);
        msg.check();
        String mtype = msg.getMType();
        HubClient recipient = this.getClient(recipientId);
        this.checkSend(caller, recipient, mtype);
        try {
            recipient.getCallable().receiveNotification(caller.getId(), msg);
        }
        catch (SampException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SampException(e.getMessage(), e);
        }
    }

    protected String call(HubClient caller, String recipientId, String msgTag, Map message) throws SampException {
        Message msg = Message.asMessage(message);
        msg.check();
        String mtype = msg.getMType();
        HubClient recipient = this.getClient(recipientId);
        String msgId = MessageId.encode(caller, msgTag, false);
        this.checkSend(caller, recipient, mtype);
        try {
            recipient.getCallable().receiveCall(caller.getId(), msgId, msg);
        }
        catch (SampException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SampException(e.getMessage(), e);
        }
        return msgId;
    }

    protected List notifyAll(HubClient caller, Map message) throws SampException {
        Message msg = Message.asMessage(message);
        msg.check();
        String mtype = msg.getMType();
        HubClient[] recipients = this.clientSet_.getClients();
        ArrayList<String> sentList = new ArrayList<String>();
        for (int ic = 0; ic < recipients.length; ++ic) {
            HubClient recipient = recipients[ic];
            if (recipient == caller || !this.canSend(caller, recipient, mtype) || !this.clientSet_.containsClient(recipient)) continue;
            try {
                recipient.getCallable().receiveNotification(caller.getId(), msg);
                sentList.add(recipient.getId());
                continue;
            }
            catch (Exception e) {
                this.logger_.log(Level.WARNING, "Notification " + caller + " -> " + recipient + " failed: " + e, e);
            }
        }
        return sentList;
    }

    protected Map callAll(HubClient caller, String msgTag, Map message) throws SampException {
        Message msg = Message.asMessage(message);
        msg.check();
        String mtype = msg.getMType();
        String msgId = MessageId.encode(caller, msgTag, false);
        HubClient[] recipients = this.clientSet_.getClients();
        HashMap<String, String> sentMap = new HashMap<String, String>();
        for (int ic = 0; ic < recipients.length; ++ic) {
            HubClient recipient = recipients[ic];
            if (recipient == caller || !this.canSend(caller, recipient, mtype) || !this.clientSet_.containsClient(recipient)) continue;
            try {
                recipient.getCallable().receiveCall(caller.getId(), msgId, msg);
            }
            catch (SampException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SampException(e.getMessage(), e);
            }
            sentMap.put(recipient.getId(), msgId);
        }
        return sentMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reply(HubClient caller, String msgIdStr, Map resp) throws SampException {
        Response response = Response.asResponse(resp);
        response.check();
        MessageId msgId = MessageId.decode(msgIdStr);
        HubClient sender = this.getClient(msgId.getSenderId());
        String senderTag = msgId.getSenderTag();
        if (msgId.isSynch()) {
            Map map = this.waiterMap_;
            synchronized (map) {
                if (this.waiterMap_.containsKey(msgId)) {
                    if (this.waiterMap_.get(msgId) != null) {
                        throw new SampException("Response ignored - you've already sent one");
                    }
                } else {
                    throw new SampException("Response ignored - synchronous call timed out");
                }
                this.waiterMap_.put(msgId, response);
                this.waiterMap_.notifyAll();
            }
        }
        try {
            sender.getCallable().receiveResponse(caller.getId(), senderTag, response);
        }
        catch (SampException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SampException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Response callAndWait(HubClient caller, String recipientId, Map message, int timeout) throws SampException {
        Message msg = Message.asMessage(message);
        msg.check();
        String mtype = msg.getMType();
        HubClient recipient = this.getClient(recipientId);
        MessageId hubMsgId = new MessageId(caller.getId(), this.keyGen_.next(), true);
        long start = System.currentTimeMillis();
        this.checkSend(caller, recipient, mtype);
        Map map = this.waiterMap_;
        synchronized (map) {
            if (MAX_WAITERS > 0 && this.waiterMap_.size() >= MAX_WAITERS) {
                int excess = this.waiterMap_.size() - MAX_WAITERS + 1;
                ArrayList keyList = new ArrayList(this.waiterMap_.keySet());
                Collections.sort(keyList, MessageId.AGE_COMPARATOR);
                this.logger_.warning("Pending synchronous calls exceeds limit " + MAX_WAITERS + " - giving up on " + excess + " oldest");
                for (int ie = 0; ie < excess; ++ie) {
                    Object removed = this.waiterMap_.remove(keyList.get(ie));
                    if (!$assertionsDisabled && removed == null) {
                        throw new AssertionError();
                    }
                }
                this.waiterMap_.notifyAll();
            }
            this.waiterMap_.put(hubMsgId, null);
        }
        try {
            recipient.getCallable().receiveCall(caller.getId(), hubMsgId.toString(), msg);
        }
        catch (SampException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SampException(e.getMessage(), e);
        }
        timeout = Math.min(Math.max(0, timeout), Math.max(0, MAX_TIMEOUT));
        long finish = timeout > 0 ? System.currentTimeMillis() + (long)(timeout * 1000) : Long.MAX_VALUE;
        Map map2 = this.waiterMap_;
        synchronized (map2) {
            while (this.waiterMap_.containsKey(hubMsgId) && this.waiterMap_.get(hubMsgId) == null && System.currentTimeMillis() < finish) {
                long millis = finish - System.currentTimeMillis();
                if (millis <= 0L) continue;
                try {
                    this.waiterMap_.wait(millis);
                }
                catch (InterruptedException e) {
                    throw new SampException("Wait interrupted", e);
                }
            }
            if (!this.waiterMap_.containsKey(hubMsgId)) {
                throw new SampException("Synchronous call aborted - server load exceeded maximum of " + MAX_WAITERS + "?");
            }
            Response response = (Response)this.waiterMap_.remove(hubMsgId);
            if (response != null) {
                return response;
            }
            if (!$assertionsDisabled && System.currentTimeMillis() < finish) {
                throw new AssertionError();
            }
            String millis = Long.toString(System.currentTimeMillis() - start);
            String emsg = "Synchronous call timeout after " + millis.substring(0, millis.length() - 3) + '.' + millis.substring(millis.length() - 3) + '/' + timeout + " sec";
            throw new SampException(emsg);
        }
    }

    public HubConnection getServiceConnection() {
        return this.serviceClientConnection_;
    }

    public void disconnect(String clientId, String reason) {
        Message discoMsg = new Message("samp.hub.disconnect");
        if (reason != null && reason.length() > 0) {
            discoMsg.addParam("reason", reason);
        }
        this.disconnect(new String[]{clientId}, discoMsg);
    }

    private void disconnect(String[] clientIds, Message discoMsg) {
        int ic;
        for (ic = 0; ic < clientIds.length; ++ic) {
            String clientId = clientIds[ic];
            HubClient client = this.clientSet_.getFromPublicId(clientId);
            if (client == null) continue;
            if (client.isSubscribed(discoMsg.getMType())) {
                try {
                    this.notify(this.serviceClient_, clientId, discoMsg);
                }
                catch (SampException e) {
                    this.logger_.log(Level.INFO, discoMsg.getMType() + " to " + client + " failed", e);
                }
            }
            this.clientSet_.remove(client);
        }
        for (ic = 0; ic < clientIds.length; ++ic) {
            this.hubEvent(new Message("samp.hub.event.unregister").addParam("id", clientIds[ic]));
        }
    }

    public boolean isHubRunning() {
        return this.started_ && !this.shutdown_;
    }

    public synchronized void shutdown() {
        if (!this.shutdown_) {
            this.shutdown_ = true;
            if (this.started_) {
                this.hubEvent(new Message("samp.hub.event.shutdown"));
            }
            this.serviceClientConnection_ = null;
        }
    }

    private void hubEvent(Message msg) {
        block2: {
            try {
                this.notifyAll(this.serviceClient_, msg);
            }
            catch (SampException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    private HubClient getClient(String id) throws SampException {
        HubClient client = this.clientSet_.getFromPublicId(id);
        if (client != null) {
            return client;
        }
        if (this.idGen_.hasUsed(id)) {
            throw new SampException("Client " + id + " is no longer registered");
        }
        throw new SampException("No registered client with ID \"" + id + "\"");
    }

    private void checkSend(HubClient sender, HubClient recipient, String mtype) throws SampException {
        String errmsg = this.getSendError(sender, recipient, mtype);
        if (errmsg != null) {
            throw new SampException(errmsg);
        }
    }

    private boolean canSend(HubClient sender, HubClient recipient, String mtype) {
        return this.getSendError(sender, recipient, mtype) == null;
    }

    private String getSendError(HubClient sender, HubClient recipient, String mtype) {
        Map subsInfo;
        if (!recipient.isCallable()) {
            return "Client " + recipient + " is not callable";
        }
        Subscriptions subs = recipient.getSubscriptions();
        if (!subs.isSubscribed(mtype)) {
            return "Client " + recipient + " is not subscribed to " + mtype;
        }
        ProfileToken ptoken = sender.getProfileToken();
        MessageRestriction mrestrict = ptoken.getMessageRestriction();
        if (mrestrict != null && !mrestrict.permitSend(mtype, subsInfo = subs.getSubscription(mtype))) {
            return "MType " + mtype + " blocked from " + ptoken + " profile";
        }
        return null;
    }

    private Subscriptions getSubscriptionsFor(HubClient client, Subscriptions subs) {
        MessageRestriction mrestrict = client.getProfileToken().getMessageRestriction();
        if (mrestrict == null) {
            return subs;
        }
        Subscriptions csubs = new Subscriptions();
        Iterator it = subs.entrySet().iterator();
        while (it.hasNext()) {
            Map note;
            Map.Entry entry = (Map.Entry)it.next();
            String mtype = (String)entry.getKey();
            if (!mrestrict.permitSend(mtype, note = (Map)entry.getValue())) continue;
            csubs.put(mtype, note);
        }
        return csubs;
    }

    static {
        $assertionsDisabled = !BasicHubService.class.desiredAssertionStatus();
        INTERNAL_PROFILE = new ProfileToken(){

            public String getProfileName() {
                return "Internal";
            }

            public MessageRestriction getMessageRestriction() {
                return null;
            }
        };
        MAX_TIMEOUT = 43200;
        MAX_WAITERS = 100;
    }

    private static class ClientIdGenerator {
        private int iseq_;
        private final String prefix_;
        private final Comparator comparator_;

        public ClientIdGenerator(String prefix) {
            this.prefix_ = prefix;
            this.comparator_ = new Comparator(){

                public int compare(Object o1, Object o2) {
                    String s1 = o1.toString();
                    String s2 = o2.toString();
                    Integer i1 = ClientIdGenerator.this.getIndex(s1);
                    Integer i2 = ClientIdGenerator.this.getIndex(s2);
                    if (i1 == null && i2 == null) {
                        return s1.compareTo(s2);
                    }
                    if (i1 == null) {
                        return 1;
                    }
                    if (i2 == null) {
                        return -1;
                    }
                    return i1 - i2;
                }
            };
        }

        public synchronized String next() {
            return this.prefix_ + Integer.toString(++this.iseq_);
        }

        public boolean hasUsed(String id) {
            Integer ix = this.getIndex(id);
            return ix != null && ix <= this.iseq_;
        }

        private Integer getIndex(String id) {
            if (id.startsWith(this.prefix_)) {
                try {
                    int iseq = Integer.parseInt(id.substring(this.prefix_.length()));
                    return new Integer(iseq);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return null;
        }

        public Comparator getComparator() {
            return this.comparator_;
        }
    }

    private static class MessageId {
        private final String senderId_;
        private final String senderTag_;
        private final boolean isSynch_;
        private final long birthday_;
        private static final String T_SYNCH_FLAG = "S";
        private static final String F_SYNCH_FLAG = "A";
        private static final int CHECK_SEED;
        private static final int CHECK_LENG = 4;
        private static final Comparator AGE_COMPARATOR;
        static final /* synthetic */ boolean $assertionsDisabled;

        public MessageId(String senderId, String senderTag, boolean isSynch) {
            this.senderId_ = senderId;
            this.senderTag_ = senderTag;
            this.isSynch_ = isSynch;
            this.birthday_ = System.currentTimeMillis();
        }

        public String getSenderId() {
            return this.senderId_;
        }

        public String getSenderTag() {
            return this.senderTag_;
        }

        public boolean isSynch() {
            return this.isSynch_;
        }

        public int hashCode() {
            return MessageId.checksum(this.senderId_, this.senderTag_, this.isSynch_).hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof MessageId) {
                MessageId other = (MessageId)o;
                return this.senderId_.equals(other.senderId_) && this.senderTag_.equals(other.senderTag_) && this.isSynch_ == other.isSynch_;
            }
            return false;
        }

        public String toString() {
            String checksum = MessageId.checksum(this.senderId_, this.senderTag_, this.isSynch_);
            return this.senderId_ + '_' + (this.isSynch_ ? T_SYNCH_FLAG : F_SYNCH_FLAG) + '_' + checksum + '_' + this.senderTag_;
        }

        public static MessageId decode(String msgId) throws SampException {
            boolean isSynch;
            int delim1 = msgId.indexOf(95);
            int delim2 = msgId.indexOf(95, delim1 + 1);
            int delim3 = msgId.indexOf(95, delim2 + 1);
            if (delim1 < 0 || delim2 < 0 || delim3 < 0) {
                throw new SampException("Badly formed message ID " + msgId);
            }
            String senderId = msgId.substring(0, delim1);
            String synchFlag = msgId.substring(delim1 + 1, delim2);
            String checksum = msgId.substring(delim2 + 1, delim3);
            String senderTag = msgId.substring(delim3 + 1);
            if (T_SYNCH_FLAG.equals(synchFlag)) {
                isSynch = true;
            } else if (F_SYNCH_FLAG.equals(synchFlag)) {
                isSynch = false;
            } else {
                throw new SampException("Badly formed message ID " + msgId + " (synch flag)");
            }
            if (!MessageId.checksum(senderId, senderTag, isSynch).equals(checksum)) {
                throw new SampException("Bad message ID checksum");
            }
            MessageId idObj = new MessageId(senderId, senderTag, isSynch);
            if (!$assertionsDisabled && !idObj.toString().equals(msgId)) {
                throw new AssertionError();
            }
            return idObj;
        }

        public static String encode(HubClient sender, String senderTag, boolean isSynch) {
            return new MessageId(sender.getId(), senderTag, isSynch).toString();
        }

        private static String checksum(String senderId, String senderTag, boolean isSynch) {
            int sum = CHECK_SEED;
            sum = 23 * sum + senderId.hashCode();
            sum = 23 * sum + senderTag.hashCode();
            sum = 23 * sum + (isSynch ? 3 : 5);
            String check = Integer.toHexString(sum);
            check = check.substring(Math.max(0, check.length() - 4));
            while (check.length() < 4) {
                check = "0" + check;
            }
            if (!$assertionsDisabled && check.length() != 4) {
                throw new AssertionError();
            }
            return check;
        }

        static {
            $assertionsDisabled = !(class$org$astrogrid$samp$hub$BasicHubService == null ? (class$org$astrogrid$samp$hub$BasicHubService = BasicHubService.class$("org.astrogrid.samp.hub.BasicHubService")) : class$org$astrogrid$samp$hub$BasicHubService).desiredAssertionStatus();
            CHECK_SEED = (int)System.currentTimeMillis();
            AGE_COMPARATOR = new Comparator(){

                public int compare(Object o1, Object o2) {
                    return (int)(((MessageId)o1).birthday_ - ((MessageId)o2).birthday_);
                }
            };
        }
    }
}

