/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.Serializable;
import java.util.Collection;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.focalplane.EventSender;
import org.lsst.ccs.subsystem.focalplane.LSE71Commands;
import org.lsst.ccs.subsystem.imagehandling.data.JsonFile;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;
import org.lsst.ccs.utilities.location.SensorLocation;
import org.lsst.ccs.utilities.location.SensorLocationSet;

public class ExpectedSensorsEventSender {
    private static final Logger LOG = Logger.getLogger(ExpectedSensorsEventSender.class.getName());
    private final EventSender sender;
    private final SensorLocationSet scienceLocations = new SensorLocationSet();
    private final SensorLocationSet guiderLocations = new SensorLocationSet();
    private ImageName obsId;

    ExpectedSensorsEventSender(EventSender sender) {
        this.sender = sender;
    }

    void startGuiding(ImageName imageName, SensorLocationSet guiderLocations) {
        this.obsId = imageName;
        this.guiderLocations.clear();
        this.guiderLocations.addAll((Collection)guiderLocations);
    }

    void stopGuiding() {
        if (this.scienceLocations.isEmpty()) {
            this.sendEvent();
        }
    }

    void startIntegration(ImageName imageName, LocationSet locations) {
        this.obsId = imageName;
        this.scienceLocations.clear();
        for (Location location : locations) {
            this.scienceLocations.addAll((Collection)location.getSensors());
        }
    }

    void endIntegration(LSE71Commands.ReadoutMode mode) {
        if (mode != LSE71Commands.ReadoutMode.TRUE) {
            this.scienceLocations.clear();
        }
        if (!this.scienceLocations.isEmpty() || this.guiderLocations.isEmpty()) {
            this.sendEvent();
        }
    }

    private void sendEvent() {
        TreeMap<String, String> jsonData = new TreeMap<String, String>();
        for (SensorLocation l : this.scienceLocations) {
            jsonData.put(l.toString("_"), "SCIENCE");
        }
        for (SensorLocation l : this.guiderLocations) {
            jsonData.put(l.toString("_"), "GUIDER");
        }
        JsonFile json = new JsonFile(this.obsId + "_expectedSensors.json", "expectedSensors", this.obsId, "expectedSensors", jsonData);
        LOG.log(Level.INFO, "Sending expectedSensors: {0}", json);
        this.sender.sendEvent("additionalFile", (Serializable)json);
        this.scienceLocations.clear();
        this.guiderLocations.clear();
    }
}

