/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter;

import hep.aida.ILineStyle;
import hep.aida.ref.plotter.BrushStyle;
import hep.aida.ref.plotter.IntegerStyleParameter;
import hep.aida.ref.plotter.RevolvingStyleParameter;
import hep.aida.ref.plotter.StringStyleParameter;
import hep.aida.ref.plotter.Style;
import java.util.Iterator;
import java.util.List;

public class LineStyle
extends BrushStyle
implements ILineStyle {
    @Override
    protected void initializeBaseStyle() {
        super.initializeBaseStyle();
        String[] lineTypes = new String[]{"solid", "dotted", "dashed", "dotdash"};
        this.addParameter(new StringStyleParameter("type", lineTypes[0], lineTypes));
        this.addParameter(new RevolvingStyleParameter("typeRotate", lineTypes[0]));
        this.addParameter(new StringStyleParameter("typeRotateMethod", Style.ROTATE_METHOD[1], Style.ROTATE_METHOD));
        this.addParameter(new IntegerStyleParameter("thickness", 2));
        String defaultRotation = lineTypes[0];
        for (int i = 1; i < lineTypes.length; ++i) {
            defaultRotation = defaultRotation + ", " + lineTypes[i];
        }
        this.setParameterDefault("typeRotate", defaultRotation);
    }

    public String[] availableLineTypes() {
        return this.availableParameterOptions("type");
    }

    public String lineType() {
        return ((StringStyleParameter)this.deepestSetParameter("type")).value();
    }

    public String lineType(int globalIndex, int overlayIndex) {
        if (this.isParameterSet("type", false)) {
            return this.parameter("type").parValue();
        }
        if (this.isParameterSet("typeRotate", false)) {
            if (this.parameterValue("typeRotateMethod") == Style.ROTATE_METHOD[0]) {
                return ((RevolvingStyleParameter)this.parameter("typeRotate")).parameterValue(globalIndex);
            }
            return ((RevolvingStyleParameter)this.parameter("typeRotate")).parameterValue(overlayIndex);
        }
        List parents = this.parentList();
        if (parents != null) {
            Iterator it = parents.iterator();
            while (it.hasNext()) {
                String tmp;
                LineStyle pbs = null;
                Object obj = it.next();
                if (!(obj instanceof LineStyle) || (tmp = (pbs = (LineStyle)obj).color(globalIndex, overlayIndex)) == null) continue;
                return tmp;
            }
        }
        return null;
    }

    public boolean setLineType(String lineType) {
        return ((StringStyleParameter)this.parameter("type")).setValue(lineType);
    }

    public boolean setThickness(int lineThickness) {
        return ((IntegerStyleParameter)this.parameter("thickness")).setValue(lineThickness);
    }

    public int thickness() {
        return ((IntegerStyleParameter)this.deepestSetParameter("thickness")).value();
    }
}

