/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.cluster.monitor;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.jgroups.util.StackType;
import org.jgroups.util.Util;
import org.lsst.ccs.bus.definition.Bus;

class CustomClusterProbe {
    protected MulticastSocket mcast_sock;
    protected volatile boolean running = true;
    protected final Set<String> senders = new HashSet<String>();
    private final Map<Bus, ClusterInfo> clusterMembersByBus = new ConcurrentHashMap<Bus, ClusterInfo>();
    private String defaultDiagnosticAddress = "224.0.75.75";

    CustomClusterProbe(String diagnosticAddress) {
        if (diagnosticAddress != null && !"".equals(diagnosticAddress)) {
            this.defaultDiagnosticAddress = diagnosticAddress;
        }
    }

    private void start(List<InetAddress> addrs, InetAddress bind_addr, int port, int ttl, long timeout, List<String> query, String match, boolean weed_out_duplicates, String passcode) throws Exception {
        for (InetAddress addr : addrs) {
            boolean unicast_dest;
            boolean bl = unicast_dest = addr != null && !addr.isMulticastAddress();
            if (unicast_dest) {
                Collection<InetAddress> targets = CustomClusterProbe.getPhysicalAddresses(addr, bind_addr, port, timeout);
                if (targets == null || targets.isEmpty()) {
                    System.err.println("Found no valid hosts - terminating");
                    return;
                }
                for (InetAddress target : targets) {
                    this.sendRequest(target, bind_addr, port, ttl, query, passcode);
                }
                continue;
            }
            this.sendRequest(addr, bind_addr, port, ttl, query, passcode);
        }
        new Thread(() -> {
            Util.sleep((long)timeout);
            this.mcast_sock.close();
            this.running = false;
        }).start();
        while (this.running) {
            byte[] buf = new byte[70000];
            DatagramPacket rsp = new DatagramPacket(buf, 0, buf.length);
            try {
                this.mcast_sock.receive(rsp);
            }
            catch (Throwable t) {
                System.out.println("\n");
                break;
            }
            byte[] data = rsp.getData();
            String response = new String(data, 0, rsp.getLength());
            if (weed_out_duplicates && this.checkDuplicateResponse(response) || !CustomClusterProbe.matches(response, match)) continue;
            this.addMember(response);
        }
    }

    public Collection<ClusterInfo> getClusters() {
        return this.clusterMembersByBus.values();
    }

    private void addMember(String memberStr) {
        ClusterMemberInfo member = new ClusterMemberInfo(memberStr);
        if (!this.clusterMembersByBus.containsKey(member.clusterName)) {
            this.clusterMembersByBus.put(member.clusterName, new ClusterInfo(member.clusterName));
        }
        this.clusterMembersByBus.get(member.clusterName).add(member);
    }

    protected static Collection<InetAddress> getPhysicalAddresses(InetAddress addr, InetAddress bind_addr, int port, long timeout) throws Exception {
        DatagramSocket sock = new DatagramSocket(new InetSocketAddress(bind_addr, 0));
        byte[] payload = "member-addrs".getBytes();
        DatagramPacket probe = new DatagramPacket(payload, 0, payload.length, addr, port);
        sock.send(probe);
        new Thread(() -> {
            Util.sleep((long)timeout);
            sock.close();
        }).start();
        long end_time = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < end_time) {
            byte[] buf = new byte[70000];
            DatagramPacket rsp = new DatagramPacket(buf, 0, buf.length);
            try {
                sock.receive(rsp);
            }
            catch (Throwable t) {
                break;
            }
            byte[] data = rsp.getData();
            String response = new String(data, 0, rsp.getLength());
            Collection<InetAddress> retval = CustomClusterProbe.parseAddresses(response);
            if (retval == null || retval.isEmpty()) continue;
            return retval;
        }
        return null;
    }

    protected static Collection<InetAddress> parseAddresses(String input) throws Exception {
        String ADDRS = "member-addrs=";
        ArrayList<InetAddress> retval = new ArrayList<InetAddress>();
        int start_index = -1;
        int end_index = -1;
        if (input != null && (start_index = input.indexOf("member-addrs=")) >= 0) {
            end_index = (input = input.substring(start_index + "member-addrs=".length()).trim()).indexOf(10);
            if (end_index > 0) {
                input = input.substring(0, end_index);
            }
            List rsps = Util.parseStringList((String)input, (String)",");
            for (String tmp : rsps) {
                int index2 = tmp.lastIndexOf(58);
                if (index2 != -1) {
                    tmp = tmp.substring(0, index2);
                }
                retval.add(InetAddress.getByName(tmp));
            }
        }
        return retval;
    }

    protected void sendRequest(InetAddress addr, InetAddress bind_addr, int port, int ttl, List<String> query, String passcode) throws Exception {
        byte[] queryPayload;
        if (this.mcast_sock == null) {
            this.mcast_sock = new MulticastSocket();
            this.mcast_sock.setTimeToLive(ttl);
            if (bind_addr != null) {
                this.mcast_sock.setInterface(bind_addr);
            }
        }
        StringBuilder request = new StringBuilder();
        byte[] authenticationDigest = null;
        if (passcode != null) {
            long t1 = new Date().getTime();
            double q1 = Math.random();
            authenticationDigest = Util.createAuthenticationDigest((String)passcode, (long)t1, (double)q1);
        }
        for (int i = 0; i < query.size(); ++i) {
            request.append(query.get(i)).append(" ");
        }
        byte[] payload = queryPayload = request.toString().getBytes();
        if (authenticationDigest != null) {
            payload = new byte[authenticationDigest.length + queryPayload.length];
            System.arraycopy(authenticationDigest, 0, payload, 0, authenticationDigest.length);
            System.arraycopy(queryPayload, 0, payload, authenticationDigest.length, queryPayload.length);
        }
        DatagramPacket probe = new DatagramPacket(payload, 0, payload.length, addr, port);
        this.mcast_sock.send(probe);
    }

    private boolean checkDuplicateResponse(String response) {
        int index = response.indexOf("local_addr");
        if (index != -1) {
            String addr = CustomClusterProbe.parseAddress(response.substring(index + 1 + "local_addr".length()));
            return !this.senders.add(addr);
        }
        return false;
    }

    private static String parseAddress(String response) {
        StringTokenizer st = new StringTokenizer(response);
        return st.nextToken();
    }

    private static boolean matches(String response, String match) {
        if (response == null) {
            return false;
        }
        if (match == null) {
            return true;
        }
        int index = response.indexOf(match);
        return index > -1;
    }

    public void probeCluster(String[] args) {
        InetAddress bind_addr = null;
        ArrayList<InetAddress> addrs = new ArrayList<InetAddress>();
        int port = 0;
        int ttl = 32;
        long timeout = 500L;
        String DEFAULT_DIAG_ADDR = this.defaultDiagnosticAddress;
        String DEFAULT_DIAG_ADDR_IPv6 = "ff0e::0:75:75";
        int DEFAULT_DIAG_PORT = 7500;
        ArrayList<String> query = new ArrayList<String>();
        String match = null;
        boolean weed_out_duplicates = false;
        String passcode = null;
        try {
            for (int i = 0; i < args.length; ++i) {
                if ("-addr".equals(args[i])) {
                    addrs.add(InetAddress.getByName(args[++i]));
                    continue;
                }
                if ("-bind_addr".equals(args[i])) {
                    bind_addr = InetAddress.getByName(args[++i]);
                    continue;
                }
                if ("-port".equals(args[i])) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-ttl".equals(args[i])) {
                    ttl = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-timeout".equals(args[i])) {
                    timeout = Long.parseLong(args[++i]);
                    continue;
                }
                if ("-match".equals(args[i])) {
                    match = args[++i];
                    continue;
                }
                if ("-weed_out_duplicates".equals(args[i])) {
                    weed_out_duplicates = true;
                    continue;
                }
                if ("-passcode".equals(args[i])) {
                    passcode = args[++i];
                    continue;
                }
                if ("-cluster".equals(args[i])) {
                    String cluster = args[++i];
                    query.add("cluster=" + cluster);
                    continue;
                }
                if ("-help".equals(args[i]) || "-h".equals(args[i]) || "--help".equals(args[i])) {
                    CustomClusterProbe.help();
                    return;
                }
                query.add(args[i]);
            }
            if (addrs.isEmpty()) {
                StackType stack_type = Util.getIpStackType();
                boolean ipv6 = stack_type == StackType.IPv6;
                InetAddress addr = InetAddress.getByName(ipv6 ? "ff0e::0:75:75" : DEFAULT_DIAG_ADDR);
                addrs.add(addr);
            }
            if (port == 0) {
                port = 7500;
            }
            this.start(addrs, bind_addr, port, ttl, timeout, query, match, weed_out_duplicates, passcode);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static void help() {
        System.out.println("Probe [-help] [-addr <addr>] [-bind_addr <addr>] [-port <port>] [-ttl <ttl>] [-timeout <timeout>] [-passcode <code>] [-weed_out_duplicates] [-cluster regexp-pattern] [-match pattern] [key[=value]]*\n\nExamples:\nprobe.sh keys // dumps all valid commands\nprobe.sh jmx=NAKACK // dumps JMX info about all NAKACK protocols\nprobe.sh op=STABLE.runMessageGarbageCollection // invokes the method in all STABLE protocols\nprobe.sh jmx=UDP.oob,thread_pool // dumps all attrs of UDP starting with oob* or thread_pool*\nprobe.sh jmx=FLUSH.bypass=true\n");
    }

    public static class ClusterMemberInfo {
        String memberName;
        private final Bus clusterName;
        final String viewName;
        int viewId;
        final int viewSize;
        final List<String> members;

        ClusterMemberInfo(String memberStr) {
            String[] lines = memberStr.split("\n");
            this.memberName = lines[0].replace("local_addr=", "");
            this.memberName = this.memberName.substring(0, this.memberName.indexOf(" "));
            this.clusterName = Bus.valueOf((String)lines[1].replace("cluster=", "").trim());
            String viewInfo = lines[2].replace("view=[", "");
            this.viewName = viewInfo.substring(0, viewInfo.indexOf("|"));
            this.viewId = Integer.parseInt(viewInfo.substring(viewInfo.indexOf("|") + 1, viewInfo.indexOf("]")));
            this.viewSize = Integer.parseInt(viewInfo.substring(viewInfo.indexOf("(") + 1, viewInfo.indexOf(")")));
            this.members = Arrays.asList(viewInfo.substring(viewInfo.lastIndexOf("[") + 1, viewInfo.lastIndexOf("]")).split(", "));
        }

        public String getMemberName() {
            return this.memberName;
        }
    }

    public static class ClusterInfo
    extends ArrayList<ClusterMemberInfo> {
        final Bus clusterName;

        ClusterInfo(Bus clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public boolean add(ClusterMemberInfo e) {
            return super.add(e);
        }
    }
}

