/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.subsystem.common.actions.RebPowerAction;
import org.lsst.ccs.subsystem.power.RebPowerSupplyNode;
import org.lsst.ccs.subsystem.power.alerts.RebPowerAlertType;

public class RebPowerAlarm
extends Alarm {
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    RebPowerSupplyNode rebNode;
    RebPowerAlertType alertType = null;

    public void build() {
        if (this.rebNode == null) {
            throw new RuntimeException("A RebPowerAlarm must defined within a RebPowerSupplyNode.");
        }
        if (this.alertType == null) {
            throw new RuntimeException("An alert type must be specified.");
        }
        super.build();
        this.description = this.alertType.getDescription();
    }

    RebPowerSupplyNode getRebNode() {
        return this.rebNode;
    }

    public Alert getAlert(AlertState state, AlertState previousAlertState) {
        Alert alert = RebPowerAlarm.getRebPowerAlert(this.alertType, this.rebNode.rebPath);
        if ((this.alertType == RebPowerAlertType.HVBIAS_CURRENT_TOO_HIGH || this.alertType == RebPowerAlertType.HVBIAS_VOLTAGE_TOO_HIGH) && state == AlertState.ALARM) {
            RebPowerAction.addRebPowerActionPayloadToAlert((Alert)alert, (RebPowerAction.Type)RebPowerAction.Type.TURN_REB_HVBIAS_OFF, (String)this.rebNode.rebPath);
        }
        return alert;
    }

    public static Alert getRebPowerAlert(RebPowerAlertType type, String rebPath) {
        return new Alert(type.getAlertId() + "/" + rebPath, type.getDescription());
    }
}

