/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.pathfinder.alerts;

import org.lsst.ccs.bus.data.Alert;

public enum PathfinderAlerts {
    VACUUM_PLC_NOT_ALIVE("VacuumPLCNotAlive", "Vacuum PLC not alive"),
    HX_VACUUM_BAD("HxVacuumBad", "HX Vacuum Bad"),
    HX_GATE_FORCED_SHUT("HxGateForcedShut", "HX Gate Valve Forced Shut"),
    HX_GATE_CANNOT_OPEN("HxGateCannotOpen", "HX Gate Valve Cannot Open"),
    HX_TURBO_PUMP_BAD("HxTurboPumpBad", "HX Turbo Pump Bad"),
    HX_TURBO_PUMP_STOPPED("HxTurboPumpStopped", "HX Turbo Pump Stopped by CCS"),
    HX_ION_PUMPS_STOPPED("HxIonPumpsStopped", "HX Ion Pumps Stopped by CCS"),
    HX_GATE_CLOSED("HxGateClosed", "HX Gate Valve Closed by CCS"),
    REFRIG_NOT_PERMITTED("RefrigNotPermitted", "Refrig permits removed by CCS"),
    PRESSURE_TOO_LOW("PressureLow", "Alert raised when the pressure too low"),
    PRESSURE_TOO_HIGH("PressureHigh", "Alert raised when the pressure too high"),
    UPS_ON_BATTERY("UPSOnBattery", "Alert raised when UPS goes onto battery"),
    UPS_DISCONNECTED("UPSDisconnected", "Alert raised when UPS becomes disconnected"),
    TURBO_PUMP_FAIL("TurboPumpFailure", "Alert raised when TurboPump status is Fail"),
    TURBO_PUMP_OVERTEMP("TurboPumpOverTemp", "Alert raised when TurboPump temperature is too high"),
    LOAD_RTD_OVERTEMP("LoadRTDTemp", "Alert raised when a Load RTD temperature is too high"),
    TEMP_MAX_TOO_HIGH("PFTempHiMaxAlarm", "Alert raised when the max temperature is too high"),
    GENERIC("GenericAlert", "Generic Alert");

    private final String id;
    private final String description;

    private PathfinderAlerts(String id, String description) {
        this.id = id;
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public Alert getAlert() {
        return this.getAlert(null);
    }

    private Alert getAlert(String prefix) {
        String aId = null;
        aId = prefix != null && !prefix.isEmpty() ? prefix + "/" + this.id : this.id;
        return new Alert(aId, this.description);
    }
}

