/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.IOException;
import java.util.logging.Logger;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.subsystem.focalplane.CCSImageList;
import org.lsst.ccs.utilities.location.LocationSet;

abstract class CCSPlayList {
    private static final Logger LOG = Logger.getLogger(CCSPlayList.class.getName());
    private final CCSImageList imageList;
    private final boolean repeat;
    private int index;

    CCSPlayList(CCSImageList imageList, boolean repeat) {
        this.imageList = imageList;
        this.repeat = repeat;
        this.index = 0;
    }

    String getName() {
        return this.imageList.getName();
    }

    boolean hasNextImage() {
        return this.index < this.imageList.size();
    }

    String peekNextImage() {
        return this.hasNextImage() ? this.imageList.get(this.index) : null;
    }

    void playNextImage(String triggeredImageName, LocationSet effectiveLocations, int opCode, String annotation) throws IOException, DAQException {
        if (!this.hasNextImage()) {
            throw new IOException("Playlist exhausted " + this);
        }
        String currentImageName = this.imageList.get(this.index++);
        if (this.index >= this.imageList.size() && this.repeat) {
            this.index = 0;
        }
        this.play(currentImageName, triggeredImageName, effectiveLocations, opCode, annotation);
    }

    public String toString() {
        String next = this.peekNextImage();
        return "CCSPlayList{name=" + this.getName() + ", index=" + this.index + ", size=" + this.imageList.size() + ", repeat=" + this.repeat + ", nextImage=" + (next == null ? "None" : next) + '}';
    }

    abstract void play(String var1, String var2, LocationSet var3, int var4, String var5) throws DAQException, IOException;
}

