/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling.imagedb;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.imagedb.ImageDatabaseService;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.SensorLocation;

public class ImageFileDatabase
implements AutoCloseable {
    private static final int MAX_RETRIES = 1;
    private Connection conn;
    private static final Logger LOG = Logger.getLogger(ImageFileDatabase.class.getName());
    private final ImageDatabaseService imageDatabaseService;
    private final String host;
    private PreparedStatement stmt1;
    private PreparedStatement stmt2;
    private PreparedStatement stmt3;

    public ImageFileDatabase(ImageDatabaseService imageDatabaseService) {
        String localHost;
        this.imageDatabaseService = imageDatabaseService;
        try {
            localHost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            localHost = "Unknown";
        }
        this.host = localHost;
    }

    public void openConnection() throws SQLException {
        this.conn = this.imageDatabaseService.openConnection();
        try (PreparedStatement stmt = this.conn.prepareStatement("create table if not exists ccs_image_file (\nfile_id int not null AUTO_INCREMENT,\ntelCode varchar(2) not null,\nseqnum integer not null,\ndayobs varchar(8) not null,\ncontroller varchar(2) not null,\nfileType varchar(24) not null,\nraft varchar(3) not null,\nsensor varchar(3) not null,\nwriteHost varchar(64) not null,\nwriteFile varchar(255) not null,\nprimary key (telCode, seqnum, dayobs, controller, fileType, raft, sensor),\nindex(file_id)\n)");){
            stmt.execute();
        }
        stmt = this.conn.prepareStatement("create table if not exists ccs_image_file_operation (\nfile_id int not null,\noperation varchar(20) not null,\noperation_return_code int,\ntime float not null,\nsuccess boolean not null,\nreason varchar(256),\nprimary key (file_id, operation)\n)");
        try {
            stmt.execute();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        this.stmt1 = this.conn.prepareStatement("insert into ccs_image_file (telcode, seqnum, dayobs, controller, fileType, raft, sensor, writeHost, writeFile) values (?, ?, ?, ?, ?,        ?, ?, ?, ?) ", 1);
        this.stmt2 = this.conn.prepareStatement("insert into ccs_image_file_operation (file_id, operation, operation_return_code, time, success, reason) values (?, ?, ?, ?, ?, ?)");
        this.stmt3 = this.conn.prepareStatement("insert into ccs_image_file_operation (file_id, operation, operation_return_code, time, success, reason) values (?, ?, ?, ?, ?, ?) on duplicate key update operation=values(operation), operation_return_code=values(operation_return_code), time=values(time), success=values(success), reason=values(reason)");
    }

    public synchronized int insertFile(ImageName obsId, SensorLocation location, String fileType, String file) throws SQLException {
        int i = 0;
        while (true) {
            if (this.conn == null || this.conn.isClosed()) {
                this.openConnection();
            }
            try {
                int auto_id;
                this.stmt1.setString(1, obsId.getSource().getCode());
                this.stmt1.setInt(2, obsId.getNumber());
                this.stmt1.setString(3, obsId.getDateString());
                this.stmt1.setString(4, obsId.getController().getCode());
                this.stmt1.setString(5, fileType);
                if (location != null) {
                    Location rebLocation = location.getRebLocation();
                    this.stmt1.setString(6, rebLocation.getRaftName());
                    this.stmt1.setString(7, rebLocation.getSensorName(location.getSensor()));
                } else {
                    this.stmt1.setString(6, "NR");
                    this.stmt1.setString(7, "NS");
                }
                this.stmt1.setString(8, this.host);
                this.stmt1.setString(9, file);
                this.stmt1.execute();
                try (ResultSet rs = this.stmt1.getGeneratedKeys();){
                    rs.next();
                    auto_id = rs.getInt(1);
                }
                this.conn.commit();
                return auto_id;
            }
            catch (SQLException x) {
                if (i < 1) {
                    LOG.log(Level.FINE, "Database update failed, retrying", x);
                    try {
                        this.close();
                    }
                    catch (SQLException sQLException) {}
                } else {
                    throw x;
                }
                ++i;
                continue;
            }
            break;
        }
    }

    Connection getConnection() {
        return this.conn;
    }

    @Override
    public void close() throws SQLException {
        if (this.conn != null) {
            this.imageDatabaseService.closeConnection();
            this.conn = null;
        }
    }

    public synchronized void insertFileOperations(List<Operation> operations, boolean ins_update) throws SQLException {
        int i = 0;
        while (true) {
            if (this.conn == null || this.conn.isClosed()) {
                this.openConnection();
            }
            PreparedStatement stmt_exec = this.stmt2;
            if (ins_update) {
                stmt_exec = this.stmt3;
            }
            try {
                for (Operation operation : operations) {
                    stmt_exec.setInt(1, operation.fileId);
                    stmt_exec.setString(2, operation.operation);
                    stmt_exec.setInt(3, operation.operation_return_code);
                    stmt_exec.setFloat(4, operation.time);
                    stmt_exec.setBoolean(5, operation.success);
                    stmt_exec.setString(6, operation.reason);
                    stmt_exec.addBatch();
                }
                stmt_exec.executeBatch();
                this.conn.commit();
                return;
            }
            catch (SQLException x) {
                if (i < 1) {
                    LOG.log(Level.FINE, "Database update failed, retrying", x);
                    try {
                        this.close();
                    }
                    catch (SQLException sQLException) {}
                } else {
                    throw x;
                }
                ++i;
                continue;
            }
            break;
        }
    }

    public synchronized List<String> missingFileNames(Date dateBefore) throws SQLException {
        ArrayList<String> fileNames = new ArrayList<String>();
        try {
            PreparedStatement stmt = this.conn.prepareStatement("select ccs_image_file.file_id, ccs_image_file.writeFile  from ccs_image_file left join ccs_image_file_operation on ccs_image_file.file_id = ccs_image_file_operation.file_id where ccs_image_file_operation.file_id is null and ccs_image_file.dayobs < ? and ccs_image_file.writeHost = ?");
            stmt.setString(1, dateBefore.toString().replace("-", ""));
            stmt.setString(2, this.host);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                fileNames.add(rs.getString("writeFile"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return fileNames;
    }

    public synchronized List<String> failedOperationFileNames(Date dateBefore) throws SQLException {
        ArrayList<String> failedOperationFileNames = new ArrayList<String>();
        try {
            PreparedStatement stmt = this.conn.prepareStatement("select ccs_image_file.writeFile, ccs_image_file_operation.file_id from ccs_image_file join ccs_image_file_operation on ccs_image_file.file_id = ccs_image_file_operation.file_id where ccs_image_file_operation.operation_return_code > 0 and ccs_image_file.dayobs < ? and ccs_image_file.writeHost = ?");
            stmt.setString(1, dateBefore.toString().replace("-", ""));
            stmt.setString(2, this.host);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                failedOperationFileNames.add(rs.getString("writeFile"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return failedOperationFileNames;
    }

    public synchronized List<MissingFile> missingFailedUSDFFileNames(String dayobs, int limit) throws SQLException {
        ArrayList<MissingFile> missingFiles = new ArrayList<MissingFile>();
        PreparedStatement stmt = this.conn.prepareStatement("    select distinct f.file_id, f.writeFile, f.fileType, f.dayobs from ccs_image_file f\n    left join ccs_image_file_operation o on (f.file_id=o.file_id and operation like 'usdf_%_copy')\n    where dayobs=? and writeHost=? and (success is null or success is false)\n    order by f.writeFile limit ?\n");
        stmt.setString(1, dayobs);
        stmt.setString(2, this.host);
        stmt.setInt(3, limit);
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            MissingFile missingFile = new MissingFile(rs.getInt(1), rs.getString(2), rs.getString(3), rs.getString(4));
            missingFiles.add(missingFile);
        }
        return missingFiles;
    }

    public record Operation(int fileId, String operation, int operation_return_code, float time, boolean success, String reason) {
    }

    public record MissingFile(int fileId, String file, String fileType, String dayobs) {
    }
}

