/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.drivers.reb.ClientFactory;
import org.lsst.ccs.drivers.reb.REBException;

public class GlobalClient {
    @Deprecated
    public static final int HDW_TYPE_DAQ = 6;
    @Deprecated
    public static final int HDW_TYPE_DAQ0 = 0;
    @Deprecated
    public static final int HDW_TYPE_DAQ1 = 1;
    @Deprecated
    public static final int HDW_TYPE_DAQ2 = 2;
    @Deprecated
    public static final int HDW_TYPE_DAQ4 = 5;
    @Deprecated
    public static final int HDW_TYPE_PCI0 = 3;
    @Deprecated
    public static final int HDW_TYPE_PCI1 = 4;
    @Deprecated
    public static final int HDW_TYPE_PCI = 4;
    private Impl impl;
    private ClientFactory clientFactory = new ClientFactory();

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.impl != null) {
            this.impl.deleteGlobalClient();
        }
    }

    public void setClientFactory(ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public void open(String part) throws REBException {
        if (this.impl != null) {
            throw new REBException("Global connection already open");
        }
        Impl newImpl = this.clientFactory.createGlobalClient(6);
        newImpl.newGlobalClient(part);
        this.impl = newImpl;
    }

    public void open(int hdw, int[] ids, String[] ifcs) throws REBException {
        if (this.impl != null) {
            throw new REBException("Global connection already open");
        }
        Impl newImpl = this.clientFactory.createGlobalClient(hdw);
        newImpl.newGlobalClient(ids, ifcs);
        this.impl = newImpl;
    }

    public void close() throws REBException {
        this.checkOpen();
        this.impl.deleteGlobalClient();
        this.impl = null;
    }

    public int getHwType() throws REBException {
        this.checkOpen();
        return this.impl.getHwType();
    }

    public void setRegisterlist(int rebType, int[] registers) throws REBException {
        this.checkOpen();
        this.impl.setRegisterList(rebType, registers);
    }

    public long acquireImage(String name) throws REBException {
        this.checkOpen();
        return this.impl.triggerImage(name);
    }

    public long acquireImage(String name, String folder, int opcode, String annotation, int ... ids) throws REBException {
        this.checkOpen();
        return this.impl.triggerImage(name, folder, opcode, annotation, ids);
    }

    public long startSequencer(int opcode) throws REBException {
        this.checkOpen();
        return this.impl.startSequencer(opcode);
    }

    private void checkOpen() throws REBException {
        if (this.impl == null) {
            throw new REBException("Global connection not open");
        }
    }

    public static interface Impl {
        default public void newGlobalClient(String part) throws REBException {
        }

        default public void newGlobalClient(int[] ids, String[] ifcs) throws REBException {
        }

        default public void deleteGlobalClient() {
        }

        default public int getHwType() {
            return 1;
        }

        default public void setRegisterList(int rebType, int[] registers) {
        }

        default public long triggerImage(String name) throws REBException {
            return 1000000L * System.currentTimeMillis();
        }

        default public long triggerImage(String name, String folder, int opcode, String annotation, int ... ids) throws REBException {
            return this.triggerImage(name);
        }

        default public long startSequencer(int opcode) throws REBException {
            return 1000000L * System.currentTimeMillis();
        }
    }
}

