import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.bootstrap.BootstrapResourceUtils
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device
import org.lsst.ccs.subsystem.refrig.PrototypeColdPlateSubsystem
import org.lsst.ccs.subsystem.refrig.SimMaq20Device
import org.lsst.ccs.subsystem.refrig.ConfiguredAverageChannel;
import org.lsst.ccs.subsystem.refrig.ProtPlutoDevice
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Channel;

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()
runMode = props.getProperty("org.lsst.ccs.run.mode", "normal")
if (runMode.equals("simulation")) {
    maq20Device = SimMaq20Device
    pOffset500 = 0.0
    pScale500 = 1.0
} else {
    maq20Device = Maq20Device
    plutoDevice = ProtPlutoDevice
    pOffset500 = -125.0;
    pScale500 = 31250.0
}

CCSBuilder builder = ["prototype-cold-plate"]

builder.main (PrototypeColdPlateSubsystem) {

  /**
    * Maq20 modules in order of DIN number in LCA-19722-A:
    * DIN 09, 10, 11, 12, 20, 21
    */
    Maq20 (maq20Device, modules: ["RTD","RTD","RTD","RTD","IS", "RTD"]) {

        PSupply      (Channel, description: "ColdPlate supply pressure",
                      devcName: "Maq20", units: "psia", format: ".2f",
                      subtype: "MA4_20", type: "4", hwChan: 0,
                      offset: pOffset500, scale: pScale500,
                      checkLo:"none", checkHi:"none")

        PReturn      (Channel, description: "ColdPlate return pressure",
                      devcName: "Maq20", units: "psia", format: ".2f",
                      subtype: "MA4_20", type: "4", hwChan: 1,
                      offset: pOffset500, scale: pScale500,
                      checkLo:"none", checkHi:"none")

        TSupply      (Channel, description: "Coolant input temperature",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "5", hwChan: 0,
                      checkLo:"none", checkHi:"none")

        TCircuit1In  (Channel, description: "Circuit 1 input temperature",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "5", hwChan: 2,
                      checkLo:"none", checkHi:"none")

        TCircuit2In  (Channel, description: "Circuit 2 input temperature",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "5", hwChan: 4,
                      checkLo:"none", checkHi:"none")

        TCircuit1Out (Channel, description: "Circuit 1 output temperature",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "5", hwChan: 3,
                      checkLo:"none", checkHi:"none")

        TCircuit2Out (Channel, description: "Circuit 2 output temperature",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "5", hwChan: 5,
                      checkLo:"none", checkHi:"none")

        TReturn      (Channel, description: "Coolant return temperature",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "5", hwChan: 1,
                      checkLo:"none", checkHi:"none")

        TColdBarAvg  (ConfiguredAverageChannel, units: "\u00b0C", format: ".2f",
                      description: "Average Temperature Cold Bar RTDs",
                      checkLo:"none", checkHi:"none")

        RTD10        (Channel, description: "Temperature, Bar 0 position 1",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "0", hwChan: 0,
                      checkLo:"none", checkHi:"none")

        RTD20        (Channel, description: "Temperature, Bar 0 position 2",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "0", hwChan: 1,
                      checkLo:"none", checkHi:"none")

        RTD30        (Channel, description: "Temperature, Bar 0 position 3",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "0", hwChan: 2,
                      checkLo:"none", checkHi:"none")

        RTD11        (Channel, description: "Temperature, Bar 1 position 1",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "0", hwChan: 3,
                      checkLo:"none", checkHi:"none")

        RTD21        (Channel, description: "Temperature, Bar 1 position 2",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "0", hwChan: 4,
                      checkLo:"none", checkHi:"none")

        RTD31        (Channel, description: "Temperature, Bar 1 position 3",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "0", hwChan: 5,
                      checkLo:"none", checkHi:"none")

        RTD02        (Channel, description: "Temperature, Bar 2 position 0",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "2", hwChan: 0,
                      checkLo:"none", checkHi:"none")

        RTD12        (Channel, description: "Temperature, Bar 2 position 1",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "2", hwChan: 1,
                      checkLo:"none", checkHi:"none")

        RTD22        (Channel, description: "Temperature, Bar 2 position 2",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "2", hwChan: 2,
                      checkLo:"none", checkHi:"none")

        RTD32        (Channel, description: "Temperature, Bar 2 position 3",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "2", hwChan: 3,
                      checkLo:"none", checkHi:"none")

        RTD03        (Channel, description: "Temperature, Bar 3 position 0",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "2", hwChan: 4,
                      checkLo:"none", checkHi:"none")

        RTD13        (Channel, description: "Temperature, Bar 3 position 1",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "2", hwChan: 5,
                      checkLo:"none", checkHi:"none")

        RTD23        (Channel, description: "Temperature, Bar 3 position 2",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "1", hwChan: 0,
                      checkLo:"none", checkHi:"none")

        RTD33        (Channel, description: "Temperature, Bar 3 position 3",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "1", hwChan: 1,
                      checkLo:"none", checkHi:"none")

        RTD04        (Channel, description: "Temperature, Bar 4 position 0",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "1", hwChan: 2,
                      checkLo:"none", checkHi:"none")

        RTD14        (Channel, description: "Temperature, Bar 4 position 1",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "1", hwChan: 3,
                      checkLo:"none", checkHi:"none")

        RTD24        (Channel, description: "Temperature, Bar 4 position 2",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "1", hwChan: 4,
                      checkLo:"none", checkHi:"none")

        RTD05        (Channel, description: "Temperature, Bar 5 position 0",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "1", hwChan: 5,
                      checkLo:"none", checkHi:"none")

        RTD15        (Channel, description: "Temperature, Bar 5 position 1",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "3", hwChan: 0,
                      checkLo:"none", checkHi:"none")

        RTD25        (Channel, description: "Temperature, Bar 5 position 2",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "3", hwChan: 1,
                      checkLo:"none", checkHi:"none")

        AmbientTemp  (Channel, description: "Temperature outside enclosure",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "3", hwChan: 2,
                      checkLo:"none", checkHi:"none")

        InteriorTemp (Channel, description: "Temperature inside enclosure",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "3", hwChan: 3,
                      checkLo:"none", checkHi:"none")

    }        

    Pluto   (plutoDevice) {
        "RTD00" (Channel, description: "Temperature, Bar 0 position 0", units: "\u00b0C", format: ".2f",
                      devcName: "Pluto", hwChan: 0, type: "ADDREG:0", scale: 0.01, offset: -120.0)

        "RTD01" (Channel, description: "Temperature, Bar 1 position 0", units: "\u00b0C", format: ".2f",
                      devcName: "Pluto", hwChan: 0, type: "ADDREG:1", scale: 0.01, offset: -120.0)

        "RTD34" (Channel, description: "Temperature, Bar 4 position 3", units: "\u00b0C", format: ".2f",
                      devcName: "Pluto", hwChan: 0, type: "ADDREG:2", scale: 0.01, offset: -120.0)

        "RTD35" (Channel, description: "Temperature, Bar 5 position 3", units: "\u00b0C", format: ".2f",
                      devcName: "Pluto", hwChan: 0, type: "ADDREG:3", scale: 0.01, offset: -120.0)
    }  
}
