import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.daq.utilities.FitsService
import org.lsst.ccs.daq.utilities.FitsServiceConfiguration
import org.lsst.ccs.subsystem.imagehandling.*;
import org.lsst.ccs.utilities.ccd.*;
import java.util.List;
import org.lsst.ccs.services.AgentStatusAggregatorService;

CCSBuilder builder = ["image-handling"]

Properties buildProperties = buildProperties();
FocalPlane focalPlane = FocalPlane.createFocalPlane(buildProperties.getProperty("org.lsst.ccs.subsystem.imagehanding.rafts",""));

builder.
    "main" (ImageHandlingSubsystem) {
    
    statusAggregator (AgentStatusAggregatorService)
    fitsService (FitsService) {
        science (FitsServiceConfiguration)  
        guider (FitsServiceConfiguration)  
    }
    
    "imageHandler" (ImageHandlingClient, geometry:focalPlane) {
          "ImageHandlingConfig" (ImageHandlingConfig);
    }
}
