/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.bonnshutter;

import java.util.List;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.bonnshutter.BonnShutter;
import org.lsst.ccs.drivers.commons.DriverException;

public class TestBonnShutter {
    private final BonnShutter shutter = new BonnShutter();

    @Command(name="open", description="Open connection to the Bonn Shutter")
    public void open(String device) throws DriverException {
        this.shutter.open(device);
    }

    @Command(name="close", description="Close connection to the Bonn Shutter")
    public void close() throws DriverException {
        this.shutter.close();
    }

    @Command(name="getVersion")
    public String getVersion() throws DriverException {
        return this.shutter.getVersion();
    }

    @Command(name="getMotorFirmwareVersion")
    public List<String> getMotorFirmwareVersion() throws DriverException {
        return this.shutter.getMotorFirmwareVersion();
    }

    @Command(name="getVerboseVelocityProfileParameters")
    public List<String> getVerboseVelocityProfileParameters() throws DriverException {
        return this.shutter.getVerboseVelocityProfileParameters();
    }

    @Command(name="getVelocityProfileParameters")
    public BonnShutter.ProfileParameters getVelocityProfileParameters() throws DriverException {
        return this.shutter.getVelocityProfileParameters();
    }

    @Command(name="getOpenCloseStatus")
    public BonnShutter.OpenCloseStatus getOpenCloseStatus() throws DriverException {
        return this.shutter.getOpenCloseStatus();
    }

    @Command(name="openShutter")
    public void openShutter() throws DriverException {
        this.shutter.openShutter();
    }

    @Command
    public void closeShutter() throws DriverException {
        this.shutter.closeShutter();
    }

    @Command
    public void expose(int exposeMillis) throws DriverException {
        this.shutter.expose(exposeMillis);
    }

    @Command
    public void exposeSeries(int n, int exposeMillis, int waitMillis) throws DriverException {
        this.shutter.exposeSeries(n, exposeMillis, waitMillis);
    }

    @Command
    public void reset() throws DriverException {
        this.shutter.reset();
    }

    @Command
    public BonnShutter.Voltages getVoltages() throws DriverException {
        return this.shutter.getVoltages();
    }

    @Command
    public void moveAbsolute(BonnShutter.Blade blade, int velocity, int position) throws DriverException {
        this.shutter.moveAbsolute(blade, velocity, position);
    }

    @Command
    public void moveRelative(BonnShutter.Blade blade, int velocity, int position) throws DriverException {
        this.shutter.moveRelative(blade, velocity, position);
    }

    @Command
    public String getMotorPosition(BonnShutter.Blade blade) throws DriverException {
        return this.shutter.getMotorPosition(blade);
    }

    @Command
    public List<String> executeGenericCommand(String command) throws DriverException {
        return this.shutter.executeGenericCommand(command);
    }
}

