/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.bonnshutter;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;

public class BonnShutter
extends Ascii {
    private final Pattern OPEN_CLOSE_PATTERN = Pattern.compile("(\\d+).*", 32);
    private final int BAUD_RATE = 19200;

    public void open(String serialName) throws DriverException {
        int characteristics = BonnShutter.makeDataCharacteristics((Ascii.DataBits)Ascii.DataBits.EIGHT, (Ascii.StopBits)Ascii.StopBits.ONE, (Ascii.Parity)Ascii.Parity.NONE, (Ascii.FlowCtrl)Ascii.FlowCtrl.NONE);
        this.open(DriverConstants.ConnType.SERIAL, serialName, 19200, characteristics);
        this.setTerminator(Ascii.Terminator.CR);
        this.setTimeout(1.0);
        this.setInteractive(false);
    }

    public String getVersion() throws DriverException {
        return this.sendCommandAndWaitForSingleLineResponse("ve");
    }

    public void setInteractive(boolean mode) throws DriverException {
        this.sendCommandAndWaitForPrompt("ia " + (mode ? 0 : 1));
    }

    public List<String> getMotorFirmwareVersion() throws DriverException {
        return this.sendCommandAndWaitForMultiLineResponse("gv bl");
    }

    public List<String> getVerboseVelocityProfileParameters() throws DriverException {
        return this.sendCommandAndWaitForMultiLineResponse("sh");
    }

    public ProfileParameters getVelocityProfileParameters() throws DriverException {
        String result = this.sendCommandAndWaitForSingleLineResponse("pp");
        return new ProfileParameters(result);
    }

    public OpenCloseStatus getOpenCloseStatus() throws DriverException {
        String result = this.sendCommandAndWaitForSingleLineResponse("ss");
        Matcher matcher = this.OPEN_CLOSE_PATTERN.matcher(result);
        if (!matcher.matches()) {
            throw new DriverException("Unexpected response: " + result);
        }
        int ordinal = Integer.parseInt(matcher.group(1));
        return OpenCloseStatus.values()[ordinal];
    }

    public void openShutter() throws DriverException {
        this.sendCommandAndWaitForPrompt("os");
    }

    public void closeShutter() throws DriverException {
        this.sendCommandAndWaitForPrompt("cs");
    }

    public void expose(int exposeMillis) throws DriverException {
        this.sendCommandAndWaitForPrompt("ex " + exposeMillis);
    }

    public void exposeSeries(int n, int exposeMillis, int waitMillis) throws DriverException {
        this.sendCommandAndWaitForPrompt("xx " + exposeMillis + " " + waitMillis + " " + n);
    }

    public void reset() throws DriverException {
        this.sendCommandAndWaitForPrompt("rs");
    }

    public Voltages getVoltages() throws DriverException {
        String result = this.sendCommandAndWaitForSingleLineResponse("vo");
        return new Voltages(result);
    }

    public void moveAbsolute(Blade blade, int velocity, int position) throws DriverException {
        this.sendCommandAndWaitForPrompt("ma  " + velocity + " " + position + " " + blade.ordinal());
    }

    public void moveRelative(Blade blade, int velocity, int position) throws DriverException {
        this.sendCommandAndWaitForPrompt("mr  " + velocity + " " + position + " " + blade.ordinal());
    }

    public String getMotorPosition(Blade blade) throws DriverException {
        return this.sendCommandAndWaitForSingleLineResponse("sp " + blade.ordinal());
    }

    public List<String> executeGenericCommand(String command) throws DriverException {
        return this.sendCommandAndWaitForMultiLineResponse(command);
    }

    private void sendCommandAndWaitForPrompt(String command) throws DriverException {
        List<String> result = this.sendCommandAndWaitForMultiLineResponse(command);
        if (!result.isEmpty()) {
            throw new DriverException("Unexpected response for command: " + command);
        }
    }

    private String sendCommandAndWaitForSingleLineResponse(String command) throws DriverException {
        List<String> result = this.sendCommandAndWaitForMultiLineResponse(command);
        if (result.size() != 1) {
            throw new DriverException("Unexpected response for command: " + command);
        }
        return result.get(0);
    }

    private synchronized List<String> sendCommandAndWaitForMultiLineResponse(String command) throws DriverException {
        this.write(command);
        ArrayList<String> result = new ArrayList<String>();
        byte[] buff = new byte[1024];
        int startOfLine = 0;
        int offset = 0;
        while (true) {
            int l = this.readBytes(buff, offset);
            for (int i = offset; i < offset + l; ++i) {
                if (buff[i] == 13) {
                    String line = new String(buff, startOfLine, i);
                    result.add(line);
                    startOfLine = i + 1;
                    continue;
                }
                if (i - startOfLine == 0 && buff[i] == 10) {
                    ++startOfLine;
                    continue;
                }
                if (i - startOfLine != 1 || buff[i - 1] != 99) continue;
                if (buff[i] == 62) {
                    return result;
                }
                if (buff[i] != 63) continue;
                throw new CommandRejected(command);
            }
            offset += l;
            if (startOfLine <= 0) continue;
            System.arraycopy(buff, startOfLine, buff, 0, offset - startOfLine);
            offset -= startOfLine;
            startOfLine = 0;
        }
    }

    public static class Voltages {
        private static Pattern pattern = Pattern.compile(".* ([0-9.]+)V ([0-9.]+)V");
        private double v5;
        private double v36;

        private Voltages(String result) throws DriverException {
            Matcher matcher = pattern.matcher(result);
            if (!matcher.find()) {
                throw new DriverException("Unexpected response: " + result);
            }
            this.v5 = Double.parseDouble(matcher.group(1));
            this.v36 = Double.parseDouble(matcher.group(2));
        }

        public double getV5() {
            return this.v5;
        }

        public double getV36() {
            return this.v36;
        }

        public String toString() {
            return "Voltages{v5=" + this.v5 + ", v36=" + this.v36 + '}';
        }
    }

    public static class CommandRejected
    extends DriverException {
        private CommandRejected(String command) {
            super("Command rejected: " + command);
        }
    }

    public static class ProfileParameters {
        private final int startBladeA;
        private final int startBladeB;
        private final int bladeTravelDistance;
        private final double startVelocity;
        private final double acceleration;
        private final double maxVelocity;
        private final double threshold;
        private final double bladeTravelTime;

        private ProfileParameters(String result) {
            String[] tokens = result.split("\\s+");
            this.startBladeA = Integer.parseInt(tokens[0]);
            this.startBladeB = Integer.parseInt(tokens[1]);
            this.bladeTravelDistance = Integer.parseInt(tokens[2]);
            this.startVelocity = Double.parseDouble(tokens[3]);
            this.acceleration = Double.parseDouble(tokens[4]);
            this.maxVelocity = Double.parseDouble(tokens[5]);
            this.threshold = Double.parseDouble(tokens[6]);
            this.bladeTravelTime = Double.parseDouble(tokens[7]);
        }

        public int getStartBladeA() {
            return this.startBladeA;
        }

        public int getStartBladeB() {
            return this.startBladeB;
        }

        public int getBladeTravelDistance() {
            return this.bladeTravelDistance;
        }

        public double getStartVelocity() {
            return this.startVelocity;
        }

        public double getAcceleration() {
            return this.acceleration;
        }

        public double getMaxVelocity() {
            return this.maxVelocity;
        }

        public double getThreshold() {
            return this.threshold;
        }

        public double getBladeTravelTime() {
            return this.bladeTravelTime;
        }

        public String toString() {
            return "ProfileParameters{startBladeA=" + this.startBladeA + ", startBladeB=" + this.startBladeB + ", bladeTravelDistance=" + this.bladeTravelDistance + ", startVelocity=" + this.startVelocity + ", acceleration=" + this.acceleration + ", maxVelocity=" + this.maxVelocity + ", threshold=" + this.threshold + ", bladeTravelTime=" + this.bladeTravelTime + '}';
        }
    }

    public static enum OpenCloseStatus {
        UNKNOWN,
        OPEN,
        CLOSED_A,
        CLOSED_B;

    }

    public static enum Mode {
        A,
        B;

    }

    public static enum Blade {
        A,
        B;

    }
}

