/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.handler.codec;

import java.util.List;
import org.python.netty.channel.ChannelDuplexHandler;
import org.python.netty.channel.ChannelHandlerContext;
import org.python.netty.channel.ChannelPromise;
import org.python.netty.handler.codec.MessageToMessageDecoder;
import org.python.netty.handler.codec.MessageToMessageEncoder;
import org.python.netty.util.internal.TypeParameterMatcher;

public abstract class MessageToMessageCodec<INBOUND_IN, OUTBOUND_IN>
extends ChannelDuplexHandler {
    private final MessageToMessageEncoder<Object> encoder = new MessageToMessageEncoder<Object>(){

        @Override
        public boolean acceptOutboundMessage(Object msg2) throws Exception {
            return MessageToMessageCodec.this.acceptOutboundMessage(msg2);
        }

        @Override
        protected void encode(ChannelHandlerContext ctx, Object msg2, List<Object> out) throws Exception {
            MessageToMessageCodec.this.encode(ctx, msg2, out);
        }
    };
    private final MessageToMessageDecoder<Object> decoder = new MessageToMessageDecoder<Object>(){

        @Override
        public boolean acceptInboundMessage(Object msg2) throws Exception {
            return MessageToMessageCodec.this.acceptInboundMessage(msg2);
        }

        @Override
        protected void decode(ChannelHandlerContext ctx, Object msg2, List<Object> out) throws Exception {
            MessageToMessageCodec.this.decode(ctx, msg2, out);
        }
    };
    private final TypeParameterMatcher inboundMsgMatcher;
    private final TypeParameterMatcher outboundMsgMatcher;

    protected MessageToMessageCodec() {
        this.inboundMsgMatcher = TypeParameterMatcher.find(this, MessageToMessageCodec.class, "INBOUND_IN");
        this.outboundMsgMatcher = TypeParameterMatcher.find(this, MessageToMessageCodec.class, "OUTBOUND_IN");
    }

    protected MessageToMessageCodec(Class<? extends INBOUND_IN> inboundMessageType, Class<? extends OUTBOUND_IN> outboundMessageType) {
        this.inboundMsgMatcher = TypeParameterMatcher.get(inboundMessageType);
        this.outboundMsgMatcher = TypeParameterMatcher.get(outboundMessageType);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg2) throws Exception {
        this.decoder.channelRead(ctx, msg2);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg2, ChannelPromise promise) throws Exception {
        this.encoder.write(ctx, msg2, promise);
    }

    public boolean acceptInboundMessage(Object msg2) throws Exception {
        return this.inboundMsgMatcher.match(msg2);
    }

    public boolean acceptOutboundMessage(Object msg2) throws Exception {
        return this.outboundMsgMatcher.match(msg2);
    }

    protected abstract void encode(ChannelHandlerContext var1, OUTBOUND_IN var2, List<Object> var3) throws Exception;

    protected abstract void decode(ChannelHandlerContext var1, INBOUND_IN var2, List<Object> var3) throws Exception;
}

