/*
 * Decompiled with CFR 0.152.
 */
package org.opensplice.dds.dcps;

import DDS.Entity;
import DDS.Property;
import DDS.PropertyHolder;
import DDS.StatusCondition;
import org.opensplice.dds.dcps.EntityBase;
import org.opensplice.dds.dcps.Event;
import org.opensplice.dds.dcps.ListenerDispatcher;
import org.opensplice.dds.dcps.ReportStack;
import org.opensplice.dds.dcps.StatusConditionImpl;

public abstract class EntityImpl
extends EntityBase
implements Entity {
    private static final long serialVersionUID = 8667249067325179655L;
    StatusConditionImpl statusCondition = null;
    private ListenerDispatcher dispatcher = null;
    private boolean wait = false;

    protected abstract int notify(Event var1);

    protected int set_dispatcher(ListenerDispatcher d) {
        this.dispatcher = d;
        return 0;
    }

    protected ListenerDispatcher get_dispatcher() {
        return this.dispatcher;
    }

    protected int set_listener(long uListener, int mask) {
        int result = 0;
        long uEntity = this.get_user_object();
        result = this.jniSetListener(uEntity, uListener, mask);
        return result;
    }

    protected synchronized int set_listener_interest(int mask) {
        int result = 0;
        if (this.dispatcher != null) {
            if (mask != 0) {
                result = this.dispatcher.add(this, mask);
                if (result == 0) {
                    this.wait = true;
                }
            } else {
                result = this.set_listener(0L, mask);
                if (result == 0) {
                    this.wait_listener_disabled();
                    this.dispatcher.remove(this);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int deinit() {
        EntityImpl entityImpl = this;
        synchronized (entityImpl) {
            this.dispatcher = null;
            if (this.statusCondition != null) {
                this.statusCondition.deinit();
                this.statusCondition = null;
            }
        }
        return super.deinit();
    }

    @Override
    public int enable() {
        int result = 0;
        long uEntity = 0L;
        ReportStack.start();
        uEntity = this.get_user_object();
        result = uEntity != 0L ? this.jniEnable(uEntity) : 9;
        ReportStack.flush(this, result != 0);
        return result;
    }

    protected boolean is_enabled() {
        long uEntity = 0L;
        boolean result = false;
        uEntity = this.get_user_object();
        if (uEntity != 0L) {
            result = this.jniIsEnable(uEntity);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatusCondition get_statuscondition() {
        int result = 0;
        ReportStack.start();
        EntityImpl entityImpl = this;
        synchronized (entityImpl) {
            if (this.statusCondition == null) {
                this.statusCondition = new StatusConditionImpl();
                result = this.statusCondition.init(this);
                if (result != 0) {
                    this.statusCondition = null;
                }
            }
        }
        ReportStack.flush(this, result != 0);
        return this.statusCondition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int detach_statuscondition() {
        int result = 0;
        ReportStack.start();
        EntityImpl entityImpl = this;
        synchronized (entityImpl) {
            if (this.statusCondition != null && (result = this.statusCondition.deinit()) == 0) {
                this.statusCondition = null;
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_status_changes() {
        int result = 0;
        int status = 0;
        long uEntity = 0L;
        ReportStack.start();
        uEntity = this.get_user_object();
        if (uEntity != 0L) {
            status = this.jniGetStatusChanges(uEntity);
        } else {
            result = 9;
        }
        ReportStack.flush(this, result != 0);
        return status;
    }

    @Override
    public long get_instance_handle() {
        int result = 0;
        long handle = 0L;
        long uEntity = 0L;
        ReportStack.start();
        uEntity = this.get_user_object();
        if (uEntity != 0L) {
            handle = this.jniGetInstanceHandle(uEntity);
        } else {
            result = 9;
        }
        ReportStack.flush(this, result != 0);
        return handle;
    }

    protected int checkProperty(Property a_property) {
        int result = 0;
        ReportStack.start();
        if (result == 0 && a_property == null) {
            result = 3;
            ReportStack.report(result, "Supplied Property is null.");
        }
        if (result == 0 && a_property.name == null) {
            result = 3;
            ReportStack.report(result, "Supplied Property.name is null.");
        }
        if (result == 0 && a_property.value == null) {
            result = 3;
            ReportStack.report(result, "Supplied Property.value is null.");
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int set_property(Property a_property) {
        int result = 0;
        ReportStack.start();
        long uEntity = this.get_user_object();
        if (uEntity == 0L) {
            result = 9;
        }
        if ((result = this.checkProperty(a_property)) == 0) {
            result = 2;
            ReportStack.report(result, "Method not implemented yet.");
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    protected int checkPropertyHolder(PropertyHolder a_property) {
        int result = 0;
        ReportStack.start();
        if (result == 0 && a_property == null) {
            result = 3;
            ReportStack.report(result, "Supplied PropertyHolder is null.");
        }
        if (result == 0 && a_property.value == null) {
            result = 3;
            ReportStack.report(result, "Supplied PropertyHolder.value is null.");
        }
        if (result == 0 && a_property.value.name == null) {
            result = 3;
            ReportStack.report(result, "Supplied PropertyHolder.value.name is null.");
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_property(PropertyHolder a_property) {
        int result = 0;
        ReportStack.start();
        long uEntity = this.get_user_object();
        if (uEntity == 0L) {
            result = 9;
        }
        if ((result = this.checkPropertyHolder(a_property)) == 0) {
            result = 2;
            ReportStack.report(result, "Method not implemented yet.");
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    protected synchronized void notify_listener_disabled() {
        assert (this.wait);
        this.wait = false;
        this.notifyAll();
    }

    protected synchronized void wait_listener_disabled() {
        try {
            int wakeCount = 0;
            while (this.wait && wakeCount < 4) {
                this.wait(2500L);
                if (!this.wait) continue;
                ReportStack.deprecated(this + ": timeout or spurious wake-up happened " + ++wakeCount + " times. Will " + (wakeCount < 4 ? "" : "not") + " wait again.");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected synchronized int disable_callbacks() {
        int result = 0;
        ReportStack.start();
        long uEntity = this.get_user_object();
        if (uEntity != 0L) {
            if (this.jniDisableCallbacks(uEntity) != 0) {
                this.wait = true;
                this.wait_listener_disabled();
            }
        } else {
            result = 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    private native int jniDisableCallbacks(long var1);

    private native int jniEnable(long var1);

    private native boolean jniIsEnable(long var1);

    private native int jniGetStatusChanges(long var1);

    private native long jniGetInstanceHandle(long var1);

    private native int jniSetListener(long var1, long var3, int var5);
}

