/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.kafka;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class SALKafkaHashTable {
    private final HashMap<String, String> map;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static SALKafkaHashTable read(File avroTemplatesDir, String cscName) {
        try (FileInputStream in = new FileInputStream(new File(avroTemplatesDir, cscName + "/" + cscName + "_hash_table.json"));){
            SALKafkaHashTable sALKafkaHashTable = new SALKafkaHashTable(in);
            return sALKafkaHashTable;
        }
        catch (IOException x) {
            throw new RuntimeException("Error reading hash table", x);
        }
    }

    private SALKafkaHashTable(InputStream in) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
        this.map = (HashMap)mapper.readValue(in, (TypeReference)typeRef);
    }

    String getRevCode(String salClassName) {
        int index = salClassName.indexOf(".");
        return this.map.get(salClassName.substring(index + 1));
    }
}

