/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.agilent;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.scpi.Scpi;

public class WG33250
extends Scpi {
    public static final int DEFAULT_BAUDRATE = 57600;
    private static final Map<String, Function> funcMap = new HashMap<String, Function>();
    private static final Map<String, Unit> unitMap;
    private static final Map<String, Polarity> polarityMap;

    public WG33250() {
        this.setOptions(Ascii.Option.NO_NET);
        this.setDefaultParm(57600);
    }

    public void open(DriverConstants.ConnType connType, String ident, int baudRate, int dataChar) throws DriverException {
        super.open(connType, ident, baudRate, dataChar);
        try {
            this.checkIdentification("Agilent Technologies", 0, "33250A", 0);
        }
        catch (DriverException e) {
            this.closeSilent();
            throw e;
        }
    }

    public void open(DriverConstants.ConnType connType, String ident, int baudRate) throws DriverException {
        int dataChar = WG33250.makeDataCharacteristics((Ascii.DataBits)Ascii.DataBits.EIGHT, (Ascii.StopBits)Ascii.StopBits.ONE, (Ascii.Parity)Ascii.Parity.NONE, (Ascii.FlowCtrl)Ascii.FlowCtrl.DTR);
        this.open(connType, ident, baudRate, dataChar);
    }

    public void start(Function func, double freq, double ampl, double offset) throws DriverException {
        this.start(func, String.valueOf(freq), String.valueOf(ampl), String.valueOf(offset));
    }

    public void start(Function func, Value freq, double ampl, double offset) throws DriverException {
        this.start(func, freq.name(), String.valueOf(ampl), String.valueOf(offset));
    }

    public void start(Function func, double freq, Value ampl, double offset) throws DriverException {
        this.start(func, String.valueOf(freq), ampl.name(), String.valueOf(offset));
    }

    public void start(Function func, double freq, double ampl, Value offset) throws DriverException {
        this.start(func, String.valueOf(freq), String.valueOf(ampl), offset.name());
    }

    public void start(Function func, Value freq, Value ampl, double offset) throws DriverException {
        this.start(func, freq.name(), ampl.name(), String.valueOf(offset));
    }

    public void start(Function func, Value freq, double ampl, Value offset) throws DriverException {
        this.start(func, freq.name(), String.valueOf(ampl), offset.name());
    }

    public void start(Function func, double freq, Value ampl, Value offset) throws DriverException {
        this.start(func, String.valueOf(freq), ampl.name(), offset.name());
    }

    public void start(Function func, Value freq, Value ampl, Value offset) throws DriverException {
        this.start(func, freq.name(), ampl.name(), offset.name());
    }

    private void start(Function func, String freq, String ampl, String offset) throws DriverException {
        String freqS = func == Function.DC || func == Function.NOISE ? "DEFAULT" : freq;
        String amplS = func == Function.DC ? "DEFAULT" : ampl;
        this.writeCommand("APPL:" + func.name() + " " + freqS + "," + amplS + "," + offset);
    }

    public void setFunction(Function func) throws DriverException {
        this.writeCommand("FUNC " + func.name());
    }

    public Function getFunction() throws DriverException {
        String funcS = this.readString("FUNC?");
        Function func = funcMap.get(funcS);
        if (func == null) {
            throw new DriverException("Unrecognized function returned (" + funcS + ")");
        }
        return func;
    }

    public void setFrequency(double freq) throws DriverException {
        this.writeCommand("FREQ " + freq);
    }

    public void setFrequency(Limit limit) throws DriverException {
        this.writeCommand("FREQ " + limit.name());
    }

    public double getFrequency() throws DriverException {
        return this.readDouble("FREQ?");
    }

    public double getFrequency(Limit limit) throws DriverException {
        return this.readDouble("FREQ? " + limit.name());
    }

    public void setAmplitude(double ampl) throws DriverException {
        this.writeCommand("VOLT " + ampl);
    }

    public void setAmplitude(Limit limit) throws DriverException {
        this.writeCommand("VOLT " + limit.name());
    }

    public double getAmplitude() throws DriverException {
        return this.readDouble("VOLT?");
    }

    public double getAmplitude(Limit limit) throws DriverException {
        return this.readDouble("VOLT? " + limit.name());
    }

    public void setOffset(double offset) throws DriverException {
        this.writeCommand("VOLT:OFFS " + offset);
    }

    public void setOffset(Limit limit) throws DriverException {
        this.writeCommand("VOLT:OFFS " + limit.name());
    }

    public double getOffset() throws DriverException {
        return this.readDouble("VOLT:OFFS?");
    }

    public double getOffset(Limit limit) throws DriverException {
        return this.readDouble("VOLT:OFFS? " + limit.name());
    }

    public void setHighLevel(double level) throws DriverException {
        this.writeCommand("VOLT:HIGH " + level);
    }

    public void setHighLevel(Limit limit) throws DriverException {
        this.writeCommand("VOLT:HIGH " + limit.name());
    }

    public double getHighLevel() throws DriverException {
        return this.readDouble("VOLT:HIGH?");
    }

    public double getHighLevel(Limit limit) throws DriverException {
        return this.readDouble("VOLT:HIGH? " + limit.name());
    }

    public void setLowLevel(double level) throws DriverException {
        this.writeCommand("VOLT:LOW " + level);
    }

    public void setLowLevel(Limit limit) throws DriverException {
        this.writeCommand("VOLT:LOW " + limit.name());
    }

    public double getLowLevel() throws DriverException {
        return this.readDouble("VOLT:LOW?");
    }

    public double getLowLevel(Limit limit) throws DriverException {
        return this.readDouble("VOLT:LOW? " + limit.name());
    }

    public void setAutorange(Autorange value) throws DriverException {
        this.writeCommand("VOLT:RANGE:AUTO " + value.name());
    }

    public boolean isAutorangeOn() throws DriverException {
        return this.readInteger("VOLT:RANGE:AUTO?") != 0;
    }

    public void setUnit(Unit unit) throws DriverException {
        this.writeCommand("VOLT:UNIT " + unit.name());
    }

    public Unit getUnit() throws DriverException {
        String unitS = this.readString("VOLT:UNIT?");
        Unit unit = unitMap.get(unitS);
        if (unit == null) {
            throw new DriverException("Unrecognized unit returned (" + unitS + ")");
        }
        return unit;
    }

    public void setDutyCycle(double cycle) throws DriverException {
        this.writeCommand("FUNC:SQU:DCYC " + cycle);
    }

    public void setDutyCycle(Limit limit) throws DriverException {
        this.writeCommand("FUNC:SQU:DCYC " + limit.name());
    }

    public double getDutyCycle() throws DriverException {
        return this.readDouble("FUNC:SQU:DCYC?");
    }

    public double getDutyCycle(Limit limit) throws DriverException {
        return this.readDouble("FUNC:SQU:DCYC? " + limit.name());
    }

    public void setSymmetry(double symm) throws DriverException {
        this.writeCommand("FUNC:RAMP:SYMM " + symm);
    }

    public void setSymmetry(Limit limit) throws DriverException {
        this.writeCommand("FUNC:RAMP:SYMM " + limit.name());
    }

    public double getSymmetry() throws DriverException {
        return this.readDouble("FUNC:RAMP:SYMM?");
    }

    public double getSymmetry(Limit limit) throws DriverException {
        return this.readDouble("FUNC:RAMP:SYMM? " + limit.name());
    }

    public void setOutput(boolean on) throws DriverException {
        this.writeCommand("OUTP " + (on ? "ON" : "OFF"));
    }

    public boolean isOutputOn() throws DriverException {
        return this.readInteger("OUTP?") != 0;
    }

    public void setOutputLoad(double load) throws DriverException {
        this.writeCommand("OUTP:LOAD " + load);
    }

    public void setOutputLoad(Load load) throws DriverException {
        this.writeCommand("OUTP:LOAD " + load.name());
    }

    public double getOutputLoad() throws DriverException {
        return this.readDouble("OUTP:LOAD?");
    }

    public double getOutputLoad(Limit limit) throws DriverException {
        return this.readDouble("OUTP:LOAD? " + limit.name());
    }

    public void setPolarity(Polarity pol) throws DriverException {
        this.writeCommand("OUTP:POL " + pol.name());
    }

    public Polarity getPolarity() throws DriverException {
        String polS = this.readString("OUTP:POL?");
        Polarity pol = polarityMap.get(polS);
        if (pol == null) {
            throw new DriverException("Unrecognized polarity returned (" + polS + ")");
        }
        return pol;
    }

    public void setSyncOutput(boolean on) throws DriverException {
        this.writeCommand("OUTP:SYNC " + (on ? "ON" : "OFF"));
    }

    public boolean isSyncOutputOn() throws DriverException {
        return this.readInteger("OUTP:SYNC?") != 0;
    }

    public void setPulsePeriod(double period) throws DriverException {
        this.writeCommand("PULS:PER " + period);
    }

    public void setPulsePeriod(Limit limit) throws DriverException {
        this.writeCommand("PULS:PER " + limit.name());
    }

    public double getPulsePeriod() throws DriverException {
        return this.readDouble("PULS:PER?");
    }

    public double getPulsePeriod(Limit limit) throws DriverException {
        return this.readDouble("PULS:PER? " + limit.name());
    }

    public void setPulseWidth(double width) throws DriverException {
        this.writeCommand("PULS:WIDT " + width);
    }

    public void setPulseWidth(Limit limit) throws DriverException {
        this.writeCommand("PULS:WIDT " + limit.name());
    }

    public double getPulseWidth() throws DriverException {
        return this.readDouble("PULS:WIDT?");
    }

    public double getPulseWidth(Limit limit) throws DriverException {
        return this.readDouble("PULS:WIDT? " + limit.name());
    }

    public void setPulseTransition(double tran) throws DriverException {
        this.writeCommand("PULS:TRAN " + tran);
    }

    public void setPulseTransition(Limit limit) throws DriverException {
        this.writeCommand("PULS:TRAN " + limit.name());
    }

    public double getPulseTransition() throws DriverException {
        return this.readDouble("PULS:TRAN?");
    }

    public double getPulseTransition(Limit limit) throws DriverException {
        return this.readDouble("PULS:TRAN? " + limit.name());
    }

    static {
        funcMap.put("SIN", Function.SINUSOID);
        funcMap.put("SQU", Function.SQUARE);
        funcMap.put("RAMP", Function.RAMP);
        funcMap.put("PULS", Function.PULSE);
        funcMap.put("NOIS", Function.NOISE);
        funcMap.put("DC", Function.DC);
        funcMap.put("USER", Function.USER);
        unitMap = new HashMap<String, Unit>();
        unitMap.put("VPP", Unit.VPP);
        unitMap.put("VRMS", Unit.VRMS);
        unitMap.put("DBM", Unit.DBM);
        polarityMap = new HashMap<String, Polarity>();
        polarityMap.put("NORM", Polarity.NORMAL);
        polarityMap.put("INV", Polarity.INVERTED);
    }

    public static enum Load {
        MINIMUM,
        MAXIMUM,
        INFINITY;

    }

    public static enum Polarity {
        NORMAL,
        INVERTED;

    }

    public static enum Unit {
        VPP,
        VRMS,
        DBM;

    }

    public static enum Autorange {
        ON,
        OFF,
        ONCE;

    }

    public static enum Limit {
        MINIMUM,
        MAXIMUM;

    }

    public static enum Value {
        DEFAULT,
        MINIMUM,
        MAXIMUM;

    }

    public static enum Function {
        SINUSOID,
        SQUARE,
        RAMP,
        PULSE,
        NOISE,
        DC,
        USER;

    }
}

