/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.imagenaming.service.ImageNameService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.HasDataProviderInfos;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.events.ShutterMotionProfileFitResult;
import org.lsst.ccs.subsystem.ocsbridge.sim.ControlledSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCM;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMLockHandler;
import org.lsst.ccs.subsystem.ocsbridge.states.CalibrationState;
import org.lsst.ccs.subsystem.ocsbridge.states.FilterState;
import org.lsst.ccs.subsystem.ocsbridge.states.RaftsState;
import org.lsst.ccs.subsystem.ocsbridge.states.ShutterReadinessState;
import org.lsst.ccs.subsystem.ocsbridge.states.ShutterState;
import org.lsst.ccs.subsystem.ocsbridge.states.StandbyState;
import org.lsst.ccs.subsystem.ocsbridge.states.TakeImageReadinessState;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;

public class MCMSubsystem
extends Subsystem
implements HasLifecycle,
HasDataProviderInfos {
    private static final Logger LOG = Logger.getLogger(MCMSubsystem.class.getName());
    private final CCS ccs = new CCS();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private MCMConfig config;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private ImageNameService imageNameService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private MCMLockHandler lockHandler;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private DataProviderDictionaryService dataProviderDictionaryService;
    private MCM mcm;
    private Set<ControlledSubsystem> controlledSubsystems;

    public MCMSubsystem() {
        super("mcm", AgentInfo.AgentType.MCM);
    }

    public void init() {
        this.agentStateService.registerState(ShutterState.class, "Shutter state", (Object)this);
        this.agentStateService.registerState(TakeImageReadinessState.class, "Image readiness State", (Object)this);
        this.agentStateService.registerState(FilterState.class, "Filter State", (Object)this);
        this.agentStateService.registerState(CalibrationState.class, "Calibration State", (Object)this);
        this.agentStateService.registerState(ShutterReadinessState.class, "Shutter readiness State", (Object)this);
        this.agentStateService.registerState(RaftsState.class, "Focal plane state", (Object)this);
        this.agentStateService.registerState(StandbyState.class, "Standby state", (Object)this);
        if (this.config.hasShutterSubsystem() && this.config.getCameraType() == Camera.MAIN_CAMERA) {
            this.dataProviderDictionaryService.registerClass(ShutterMotionProfileFitResult.class, "shutter/motorEncoder/MINUSX/open/motionProfileFitResult");
            this.dataProviderDictionaryService.registerClass(ShutterMotionProfileFitResult.class, "shutter/motorEncoder/MINUSX/close/motionProfileFitResult");
            this.dataProviderDictionaryService.registerClass(ShutterMotionProfileFitResult.class, "shutter/motorEncoder/PLUSX/open/motionProfileFitResult");
            this.dataProviderDictionaryService.registerClass(ShutterMotionProfileFitResult.class, "shutter/motorEncoder/PLUSX/close/motionProfileFitResult");
            this.dataProviderDictionaryService.registerClass(ShutterMotionProfileFitResult.class, "shutter/hallSensor/MINUSX/open/motionProfileFitResult");
            this.dataProviderDictionaryService.registerClass(ShutterMotionProfileFitResult.class, "shutter/hallSensor/MINUSX/close/motionProfileFitResult");
            this.dataProviderDictionaryService.registerClass(ShutterMotionProfileFitResult.class, "shutter/hallSensor/PLUSX/open/motionProfileFitResult");
            this.dataProviderDictionaryService.registerClass(ShutterMotionProfileFitResult.class, "shutter/hallSensor/PLUSX/close/motionProfileFitResult");
        }
    }

    public void postInit() {
        this.mcm = new MCM(this.ccs, this.config, this.imageNameService);
        this.mcm.registerMCMSubsystem(this);
    }

    public void postStart() {
        this.controlledSubsystems = new HashSet<ControlledSubsystem>();
        if (this.config.hasFocalPlaneSubsystem()) {
            this.controlledSubsystems.add(this.mcm.getFocalPlane().registerMCMSubsystem(this));
        }
        if (this.config.hasShutterSubsystem()) {
            this.controlledSubsystems.add(this.mcm.getShutter().registerMCMSubsystem(this));
        }
        if (this.config.hasFilterChangerSubsystem()) {
            this.controlledSubsystems.add(this.mcm.getFilterChanger().registerMCMSubsystem(this));
        }
        for (String otherAgent : this.config.getOtherConfiguredSubsystems()) {
            this.controlledSubsystems.add(new ControlledSubsystem(this, otherAgent, this.ccs, this.config));
        }
        this.ccs.addStateChangeListener((when, state, oldState, cause) -> this.agentStateService.updateAgentState(when, new Enum[]{state}));
        ArrayList initialStates = new ArrayList();
        this.ccs.getAggregateStatus().getStates().forEach(state -> initialStates.add(state.getState()));
        this.agentStateService.updateAgentState(initialStates.toArray(new Enum[initialStates.size()]));
        this.ccs.addStatusMessageListener(msg -> this.getMessagingAccess().sendStatusMessage(msg));
        this.ccs.addEventListener(event -> this.publishSubsystemDataOnStatusBus(new KeyValueData("CCSEvent", (Serializable)event)));
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void initImage(@Argument(description="Time in seconds") double delta) throws Exception {
        CCSCommand.CCSInitImageCommand initImage = new CCSCommand.CCSInitImageCommand(delta);
        this.executeAndHandleResponse(initImage);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void startImage(boolean shutter, String sensors, String keyValueData, String annotation, double timeout) throws Exception {
        CCSCommand.CCSStartImageCommand startImage = new CCSCommand.CCSStartImageCommand(shutter, sensors, keyValueData, annotation, timeout);
        this.executeAndHandleResponse(startImage);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void takeImages(double expTime, int numImages, boolean shutter, String sensors, String keyValueData, String annotation) throws Exception {
        CCSCommand.CCSTakeImagesCommand takeImages = new CCSCommand.CCSTakeImagesCommand(expTime, numImages, shutter, sensors, keyValueData, annotation);
        this.executeAndHandleResponse(takeImages);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void setFilter(String name) throws Exception {
        CCSCommand.CCSSetFilterCommand setFilter = new CCSCommand.CCSSetFilterCommand(name);
        this.executeAndHandleResponse(setFilter);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void initGuiders(String roiSpec) throws Exception {
        CCSCommand.CCSInitGuidersCommand initGuiders = new CCSCommand.CCSInitGuidersCommand(roiSpec);
        this.executeAndHandleResponse(initGuiders);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void endImage() throws Exception {
        CCSCommand.CCSEndImageCommand endImage = new CCSCommand.CCSEndImageCommand();
        this.executeAndHandleResponse(endImage);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void clear(int nClears) throws Exception {
        CCSCommand.CCSClearCommand clear = new CCSCommand.CCSClearCommand(nClears);
        this.executeAndHandleResponse(clear);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void play(String playlist, @Argument(defaultValue="false") boolean repeat) throws Exception {
        CCSCommand.CCSPlayCommand play = new CCSCommand.CCSPlayCommand(playlist, repeat);
        this.executeAndHandleResponse(play);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void definePlaylist(String playlist, String daqFolder, String ... images) throws Exception {
        CCSCommand.CCSDefinePlaylistCommand definePlaylist = new CCSCommand.CCSDefinePlaylistCommand(playlist, daqFolder, images);
        this.executeAndHandleResponse(definePlaylist);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void discardRows(int nRows) throws Exception {
        CCSCommand.CCSDiscardRowsCommand discardRows = new CCSCommand.CCSDiscardRowsCommand(nRows);
        this.executeAndHandleResponse(discardRows);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void setHeaderKeywords(Map<String, Serializable> headersMap) throws Exception {
        CCSCommand.CCSSetHeaderKeywordsCommand setHeaderKeywords = new CCSCommand.CCSSetHeaderKeywordsCommand(headersMap);
        this.executeAndHandleResponse(setHeaderKeywords);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public ImageName allocateImageName() throws Exception {
        CCSCommand.CCSAllocateImageNameCommand allocateImage = new CCSCommand.CCSAllocateImageNameCommand();
        return (ImageName)this.executeAndHandleResponse(allocateImage);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void clearAndStartNamedIntegration(ImageName imageName, boolean shutter, int clears, String annotation, Set sensors, Map<String, Serializable> headersMap) throws Exception {
        CCSCommand.CCSClearAndStartNamedIntegrationCommand clearAndStart = new CCSCommand.CCSClearAndStartNamedIntegrationCommand(imageName, shutter, clears, annotation, sensors, headersMap);
        this.executeAndHandleResponse(clearAndStart);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void endIntegration() throws Exception {
        CCSCommand.CCSEndIntegrationCommand endIntegration = new CCSCommand.CCSEndIntegrationCommand();
        this.executeAndHandleResponse(endIntegration);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void takeImage(ImageName imageName, boolean shutter, double expTime, int clears, String annotation, Set sensors, Map<String, Serializable> headersMap) throws Exception {
        CCSCommand.CCSTakeImageCommand takeImage = new CCSCommand.CCSTakeImageCommand(imageName, shutter, expTime, clears, annotation, sensors, headersMap);
        this.executeAndHandleResponse(takeImage);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void waitForImage() throws Exception {
        CCSCommand.CCSWaitForImageCommand wait = new CCSCommand.CCSWaitForImageCommand();
        this.executeAndHandleResponse(wait);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void openShutter() throws Exception {
        CCSCommand.CCSOpenShutterCommand openShutter = new CCSCommand.CCSOpenShutterCommand();
        this.executeAndHandleResponse(openShutter);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void closeShutter() throws Exception {
        CCSCommand.CCSCloseShutterCommand closeShutter = new CCSCommand.CCSCloseShutterCommand();
        this.executeAndHandleResponse(closeShutter);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void start(String configuration) throws Exception {
        if (this.lockHandler != null) {
            this.lockHandler.lockAll();
        }
        CCSCommand.CCSStartCommand start = new CCSCommand.CCSStartCommand(configuration);
        this.executeAndHandleResponse(start);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void standby() throws Exception {
        if (this.lockHandler != null) {
            this.lockHandler.unlockAll();
        }
        CCSCommand.CCSStandbyCommand standby = new CCSCommand.CCSStandbyCommand();
        this.executeAndHandleResponse(standby);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void enableCalibration() throws Exception {
        CCSCommand.CCSEnableCalibrationCommand enableCalibration = new CCSCommand.CCSEnableCalibrationCommand();
        this.executeAndHandleResponse(enableCalibration);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void disableCalibration() throws Exception {
        CCSCommand.CCSDisableCalibrationCommand disableCalibration = new CCSCommand.CCSDisableCalibrationCommand();
        this.executeAndHandleResponse(disableCalibration);
    }

    private <T> T executeAndHandleResponse(CCSCommand command) throws Exception {
        CCSCommand.CCSCommandResponse response = this.mcm.execute(command);
        CCSCommand.CCSAckOrNack can = response.waitForAckOrNack();
        if (can.isNack()) {
            this.sendNack((Serializable)((Object)can.getReason()));
            return null;
        }
        this.sendAck(can.getDuration().plus(Duration.ofMillis(1000L)));
        return response.waitForCompletion();
    }

    public void publishDataProviderCurrentData(AgentInfo ... agents) {
        LOG.log(Level.INFO, "Spontaneous publication of current FCState for connecting agents: ", Arrays.asList(agents));
        for (ControlledSubsystem cs : this.controlledSubsystems) {
            cs.onRepublishServiceData();
        }
        this.mcm.publishDataProviderCurrentData();
    }

    Set<ControlledSubsystem> getControlledSubsystems() {
        return this.controlledSubsystems;
    }
}

