/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.imagenaming.Controller;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.imagenaming.Source;
import org.lsst.ccs.imagenaming.service.ImageNameService;
import org.lsst.ccs.subsystem.focalplane.data.ImageMetaDataEvent;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.CCSExecutor;
import org.lsst.ccs.subsystem.ocsbridge.ConfigurationSender;
import org.lsst.ccs.subsystem.ocsbridge.GUIDirectLayer;
import org.lsst.ccs.subsystem.ocsbridge.MCMLayer;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeConfig;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.SALHeartbeatGenerator;
import org.lsst.ccs.subsystem.ocsbridge.TelemetrySender;
import org.lsst.ccs.subsystem.ocsbridge.ToyOCSGUI;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSAvailableFiltersEvent;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSConfigurationAppliedEvent;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSConfigurationsAvailableEvent;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSImageNameEvent;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSSetFilterEvent;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCM;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMDirectLayer;
import org.lsst.ccs.subsystem.ocsbridge.states.RaftsState;
import org.lsst.ccs.subsystem.ocsbridge.states.ShutterState;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.DelimitedStringSplitJoin;
import org.lsst.ccs.subsystem.ocsbridge.util.OCSCommandConverter;
import org.lsst.ccs.subsystem.ocsbridge.util.OCSStateChangeToEventConverter;
import org.lsst.ccs.subsystem.ocsbridge.util.OCSStateEventConverter;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.subsystem.ocsbridge.util.SummaryInfoConverter;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;
import org.lsst.sal.atcamera.event.ImageReadoutParametersEvent;
import org.lsst.sal.atcamera.event.ShutterMotionProfileEvent;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraStateChangeEvent;
import org.lsst.sal.camera.command.DisableCommand;
import org.lsst.sal.camera.command.EnableCommand;
import org.lsst.sal.camera.command.EnterControlCommand;
import org.lsst.sal.camera.command.ExitControlCommand;
import org.lsst.sal.camera.command.InitGuidersCommand;
import org.lsst.sal.camera.command.SetAuthListCommand;
import org.lsst.sal.camera.command.StandbyCommand;
import org.lsst.sal.camera.command.StartCommand;
import org.lsst.sal.camera.command.StartImageCommand;
import org.lsst.sal.camera.command.TakeImagesCommand;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.ConfigurationAppliedEvent;
import org.lsst.sal.camera.event.ConfigurationsAvailableEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndSetFilterEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartSetFilterEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;
import org.lsst.sal.camera.states.OfflineDetailedStateEvent;
import org.lsst.sal.camera.states.SummaryStateEvent;

public class OCSBridge {
    private static final Logger LOG = Logger.getLogger(OCSBridge.class.getName());
    private static final DelimitedStringSplitJoin DELIMITED_STRING_SPLIT_JOIN = new DelimitedStringSplitJoin();
    private final CCS ccs;
    private final State lse209State;
    private final State offlineState;
    private OCSCommandExecutor ocsCommandExecutor;
    private CCSCommandExecutor ccsCommandExecutor;
    private final MCMLayer mcm;
    private BlockingQueue<CCSImageNameEvent> imageNameTransfer = new ArrayBlockingQueue<CCSImageNameEvent>(1);
    private CCSImageNameEvent imageNameEvent;
    private EndOfImageTelemetryEvent endOfImageTelemetryEvent;
    private final OCSBridgeConfig config;
    private final State commandState;
    private final OCSCommandConverter ocsCcsCommandConverter = new OCSCommandConverter();
    private final OCSStateEventConverter ocsCcsStateEventConverter = new OCSStateEventConverter();
    private final OCSStateChangeToEventConverter ocsStateChangeToEventConverter = new OCSStateChangeToEventConverter();
    private CCSTimeStamp openTime;
    private final TelemetrySender telemetrySender;
    private final ConfigurationSender configurationSender;

    OCSBridge(OCSBridgeConfig config, CCS ccs, MCMLayer mcm) {
        this.config = config;
        this.ccs = ccs;
        this.mcm = mcm;
        CCSTimeStamp now = CCSTimeStamp.currentTime();
        this.lse209State = new State<SummaryStateEvent.SummaryState>(SummaryStateEvent.SummaryState.OFFLINE);
        ccs.getAggregateStatus().add(now, this.lse209State);
        this.offlineState = new State<OfflineDetailedStateEvent.OfflineState>(OfflineDetailedStateEvent.OfflineState.OFFLINE_PUBLISH_ONLY);
        ccs.getAggregateStatus().add(now, this.offlineState);
        this.commandState = new State<CCSCommandStateEvent.CCSCommandState>(CCSCommandStateEvent.CCSCommandState.IDLE);
        ccs.getAggregateStatus().add(now, this.commandState);
        this.ocsCommandExecutor = new OCSCommandExecutor(this);
        this.ccsCommandExecutor = new CCSCommandExecutor();
        this.telemetrySender = TelemetrySender.create(config.getDevice(), this.ocsCommandExecutor, ccs.getScheduler());
        this.configurationSender = ConfigurationSender.create(config.getDevice(), this.ocsCommandExecutor);
        SALHeartbeatGenerator shg = new SALHeartbeatGenerator(this);
        shg.start();
        mcm.addStateChangeListener((when, state, oldState, cause) -> {
            CameraEvent converted;
            ImageName imageName;
            if (state instanceof OperationalState) {
                LOG.log(Level.INFO, "MCM OperationalState changed from {0} to {1}", new Object[]{oldState, state});
                if (state == OperationalState.ENGINEERING_FAULT && ccs.getAggregateStatus().anyState(new Enum[]{SummaryStateEvent.SummaryState.ENABLED, SummaryStateEvent.SummaryState.DISABLED})) {
                    LOG.log(Level.WARNING, "Switching to FAULT state");
                    this.lse209State.setState(SummaryStateEvent.SummaryState.FAULT);
                    StringBuilder sb = new StringBuilder("MCM has entered fault state");
                    if (cause == null) {
                        sb.append(" for unspecified reason");
                    } else {
                        sb.append(". Cause: ").append(cause);
                    }
                    ErrorCodeEvent ece = new ErrorCodeEvent(1099, sb.toString(), "");
                    this.ocsCommandExecutor.sendEvent((CameraEvent)ece);
                    try {
                        mcm.unlock();
                    }
                    catch (ExecutionException x) {
                        LOG.log(Level.WARNING, "Unable to release MCM lock", x);
                    }
                }
            }
            if ((oldState == RaftsState.CLEARING || oldState == RaftsState.QUIESCENT) && state == RaftsState.INTEGRATING) {
                ccs.runInBackground(() -> {
                    try {
                        long start = System.currentTimeMillis();
                        this.imageNameEvent = this.imageNameTransfer.poll(2L, TimeUnit.SECONDS);
                        long waitTime = System.currentTimeMillis() - start;
                        if (this.imageNameEvent == null) {
                            RuntimeException re = new RuntimeException("Image name could not be retrieved");
                            LOG.log(Level.SEVERE, re.getMessage(), re);
                            throw re;
                        }
                        if (waitTime > 500L) {
                            LOG.log(Level.WARNING, "Waited {0} for imageNameEvent", waitTime);
                        }
                        ImageName imageName = this.imageNameEvent.getImageName();
                        StartIntegrationEvent sie = StartIntegrationEvent.builder().additionalKeys(DELIMITED_STRING_SPLIT_JOIN.join(this.imageNameEvent.getKeyValueData().keySet())).additionalValues(DELIMITED_STRING_SPLIT_JOIN.join(this.imageNameEvent.getKeyValueData().values())).imagesInSequence(this.imageNameEvent.getImagesInSequence()).imageIndex(this.imageNameEvent.getSequenceNumber() + 1).imageName(imageName.toString()).imageNumber(imageName.getNumber()).imageSource(imageName.getSource().getCode()).imageController(imageName.getController().getCode()).imageDate(imageName.getDateString()).timestampAcquisitionStart(this.imageNameEvent.getIntegrationStartTime().getTAIDouble()).exposureTime(this.imageNameEvent.getExposureTime()).mode(this.imageNameEvent.getMode()).timeout(this.imageNameEvent.getTimeout()).build();
                        this.ocsCommandExecutor.sendEvent((CameraEvent)sie);
                    }
                    catch (InterruptedException | RuntimeException ex) {
                        LOG.log(Level.SEVERE, "Error sending StartIntegrationEvent", ex);
                    }
                });
            }
            if (oldState == RaftsState.INTEGRATING && state == RaftsState.READING_OUT) {
                if (this.imageNameEvent == null) {
                    LOG.log(Level.WARNING, "Could not send StartReadoutEvent because of an imageNameEvent was not received.");
                } else {
                    imageName = this.imageNameEvent.getImageName();
                    StartReadoutEvent sre = StartReadoutEvent.builder().additionalKeys(DELIMITED_STRING_SPLIT_JOIN.join(this.imageNameEvent.getKeyValueData().keySet())).additionalValues(DELIMITED_STRING_SPLIT_JOIN.join(this.imageNameEvent.getKeyValueData().values())).imagesInSequence(this.imageNameEvent.getImagesInSequence()).imageIndex(this.imageNameEvent.getSequenceNumber() + 1).imageName(imageName.toString()).imageNumber(imageName.getNumber()).imageSource(imageName.getSource().getCode()).imageController(imageName.getController().getCode()).imageDate(imageName.getDateString()).timestampAcquisitionStart(this.imageNameEvent.getIntegrationStartTime().getTAIDouble()).timestampStartOfReadout(when.getTAIDouble()).exposureTime(this.imageNameEvent.getExposureTime()).build();
                    this.ocsCommandExecutor.sendEvent((CameraEvent)sre);
                }
            }
            if (oldState == RaftsState.READING_OUT) {
                if (this.imageNameEvent == null) {
                    LOG.log(Level.WARNING, "Could not send EndReadoutEvent because of an imageNameEvent was not received.");
                } else {
                    imageName = this.imageNameEvent.getImageName();
                    EndReadoutEvent ere = EndReadoutEvent.builder().additionalKeys(DELIMITED_STRING_SPLIT_JOIN.join(this.imageNameEvent.getKeyValueData().keySet())).additionalValues(DELIMITED_STRING_SPLIT_JOIN.join(this.imageNameEvent.getKeyValueData().values())).imagesInSequence(this.imageNameEvent.getImagesInSequence()).imageIndex(this.imageNameEvent.getSequenceNumber() + 1).imageName(imageName.toString()).imageNumber(imageName.getNumber()).imageSource(imageName.getSource().getCode()).imageController(imageName.getController().getCode()).imageDate(imageName.getDateString()).timestampAcquisitionStart(this.imageNameEvent.getIntegrationStartTime().getTAIDouble()).timestampEndOfReadout(when.getTAIDouble()).requestedExposureTime(this.imageNameEvent.getExposureTime()).build();
                    this.ocsCommandExecutor.sendEvent((CameraEvent)ere);
                    EndOfImageTelemetryEvent endOfImageTelemetryEventAtEndReadout = this.endOfImageTelemetryEvent;
                    ccs.schedule(Duration.ofMillis(300L), () -> {
                        if (endOfImageTelemetryEventAtEndReadout != null) {
                            this.ocsCommandExecutor.sendEvent((CameraEvent)endOfImageTelemetryEventAtEndReadout);
                        }
                    });
                }
            }
            if ((converted = this.ocsStateChangeToEventConverter.convert(when, oldState, state)) != null) {
                this.ocsCommandExecutor.sendEvent(converted);
            }
            if (state == ShutterState.OPEN) {
                this.openTime = when;
            }
            if ((oldState == ShutterState.CLOSING || oldState == ShutterState.OPEN) && state == ShutterState.CLOSED) {
                CCSTimeStamp closeTime = when;
                this.ocsCommandExecutor.sendEvent((CameraEvent)new ShutterMotionProfileEvent((closeTime.getTAIDouble() - this.openTime.getTAIDouble()) / 1000.0));
            }
        });
        mcm.addEventListener(event -> {
            if (event instanceof CCSAvailableFiltersEvent) {
                List<String> filters = ((CCSAvailableFiltersEvent)event).getAvailableFilters();
                this.ocsCommandExecutor.sendEvent((CameraEvent)new AvailableFiltersEvent(DELIMITED_STRING_SPLIT_JOIN.join(filters)));
            } else if (event instanceof CCSImageNameEvent) {
                LOG.log(Level.INFO, "CCSImageNameEvent event {0}", event);
                this.imageNameTransfer.add((CCSImageNameEvent)event);
            } else if (event instanceof CCSSetFilterEvent) {
                CCSSetFilterEvent setFilter = (CCSSetFilterEvent)event;
                if (setFilter.isStart()) {
                    this.ocsCommandExecutor.sendEvent((CameraEvent)new StartSetFilterEvent(setFilter.getFilterName(), setFilter.getFilterType()));
                } else {
                    this.ocsCommandExecutor.sendEvent((CameraEvent)new EndSetFilterEvent(setFilter.getFilterName(), setFilter.getFilterType(), setFilter.getSlot(), setFilter.getPosition()));
                }
            } else if (event instanceof CCSConfigurationAppliedEvent) {
                CCSConfigurationAppliedEvent ccsEvent = (CCSConfigurationAppliedEvent)event;
                String otherEvents = this.configurationSender.getConfigurationEvents();
                this.ocsCommandExecutor.sendEvent((CameraEvent)new ConfigurationAppliedEvent(ccsEvent.getSettings(), this.makeSemverCompliant(ccsEvent.getVersion()), ccsEvent.getUrl(), ccsEvent.getSchema(), otherEvents));
            } else if (event instanceof CCSConfigurationsAvailableEvent) {
                CCSConfigurationsAvailableEvent ccsEvent = (CCSConfigurationsAvailableEvent)event;
                this.ocsCommandExecutor.sendEvent((CameraEvent)new ConfigurationsAvailableEvent(ccsEvent.getConfigurationsAvailable(), this.makeSemverCompliant(ccsEvent.getVersion()), ccsEvent.getUrl(), ccsEvent.getSchema()));
            }
        });
        mcm.addStatusMessageListener(msg -> {
            if (msg instanceof StatusConfigurationInfo) {
                StatusConfigurationInfo sci = (StatusConfigurationInfo)msg;
                AgentInfo originAgentInfo = msg.getOriginAgentInfo();
                String subsystemName = originAgentInfo == null ? "unknown" : originAgentInfo.getName();
                ConfigurationInfo info = sci.getConfigurationInfo();
                if (originAgentInfo != null && "FOCAL_PLANE".equals(originAgentInfo.getAgentProperty("agentCategory"))) {
                    SummaryInfoConverter converter = new SummaryInfoConverter(config.getDevice());
                    this.ocsCommandExecutor.sendEvent(converter.convert(info));
                }
                this.configurationSender.send(sci);
            } else if (msg instanceof StatusSubsystemData) {
                StatusSubsystemData ssd = (StatusSubsystemData)msg;
                AgentInfo originAgentInfo = msg.getOriginAgentInfo();
                String subsystemName = originAgentInfo == null ? "unknown" : originAgentInfo.getName();
                LOG.log(Level.FINE, "Received from {0} {1}", new Object[]{subsystemName, ssd.getDataKey()});
                LOG.log(Level.FINE, "Data {0}", new Object[]{ssd.getSubsystemData().getValue().toString()});
                if (ssd.getSubsystemData().getValue() instanceof org.lsst.ccs.subsystem.focalplane.data.ImageReadoutParametersEvent) {
                    org.lsst.ccs.subsystem.focalplane.data.ImageReadoutParametersEvent data = (org.lsst.ccs.subsystem.focalplane.data.ImageReadoutParametersEvent)ssd.getSubsystemData().getValue();
                    ArrayList<String> ccdNames = new ArrayList<String>();
                    ArrayList<ImageReadoutParametersEvent.CcdType> ccdTypes = new ArrayList<ImageReadoutParametersEvent.CcdType>();
                    ArrayList<Integer> overCols = new ArrayList<Integer>();
                    ArrayList<Integer> overRows = new ArrayList<Integer>();
                    ArrayList<Integer> postCols = new ArrayList<Integer>();
                    ArrayList<Integer> postRows = new ArrayList<Integer>();
                    ArrayList<Integer> preCols = new ArrayList<Integer>();
                    ArrayList<Integer> preRows = new ArrayList<Integer>();
                    ArrayList<Integer> readCols = new ArrayList<Integer>();
                    ArrayList<Integer> readCols2 = new ArrayList<Integer>();
                    ArrayList<Integer> readRows = new ArrayList<Integer>();
                    ArrayList<Integer> underCols = new ArrayList<Integer>();
                    int index = 0;
                    for (Location location : data.getLocations()) {
                        int nSensors = location.type().getCCDCount();
                        for (int i2 = 0; i2 < nSensors; ++i2) {
                            ccdNames.add(location.getRaftName() + (config.getDevice() == Camera.AUXTEL ? "S00" : location.getSensorName(i2)));
                            ccdTypes.add(ImageReadoutParametersEvent.CcdType.valueOf((String)data.getCcdType()[index].toUpperCase()));
                            overCols.add(data.getOverCols()[index]);
                            overRows.add(data.getOverRows()[index]);
                            postCols.add(data.getPostCols()[index]);
                            postRows.add(data.getPostRows()[index]);
                            preCols.add(data.getPreCols()[index]);
                            preRows.add(data.getPreRows()[index]);
                            readCols.add(data.getReadCols()[index]);
                            readCols2.add(data.getReadCols2()[index]);
                            readRows.add(data.getReadRows()[index]);
                            underCols.add(data.getUnderCols()[index]);
                        }
                        ++index;
                    }
                    Object irpe = config.getDevice() == Camera.AUXTEL ? ImageReadoutParametersEvent.builder().imageName(data.getImageName().toString()).ccdLocation(DELIMITED_STRING_SPLIT_JOIN.join(ccdNames)).raftBay(ccdNames.stream().map(name -> name.substring(0, 3)).collect(DELIMITED_STRING_SPLIT_JOIN.joining())).ccdSlot(ccdNames.stream().map(name -> name.substring(3, 6)).collect(DELIMITED_STRING_SPLIT_JOIN.joining())).ccdType(ImageReadoutParametersEvent.CcdType.ITL).overRows(((Integer)overRows.get(0)).intValue()).overCols(((Integer)overCols.get(0)).intValue()).readRows(((Integer)readRows.get(0)).intValue()).readCols(((Integer)readCols.get(0)).intValue()).readCols2(((Integer)readCols2.get(0)).intValue()).preCols(((Integer)preCols.get(0)).intValue()).preRows(((Integer)preRows.get(0)).intValue()).postCols(((Integer)postCols.get(0)).intValue()).underCols(((Integer)underCols.get(0)).intValue()).daqFolder(data.getDaqFolder()).daqAnnotation(data.getAnnotation()).build() : org.lsst.sal.camera.event.ImageReadoutParametersEvent.builder().imageName(data.getImageName().toString()).ccdLocation(DELIMITED_STRING_SPLIT_JOIN.join(ccdNames)).raftBay(ccdNames.stream().map(name -> name.substring(0, 3)).collect(DELIMITED_STRING_SPLIT_JOIN.joining())).ccdSlot(ccdNames.stream().map(name -> name.substring(3, 6)).collect(DELIMITED_STRING_SPLIT_JOIN.joining())).ccdType((ImageReadoutParametersEvent.CcdType[])ccdTypes.stream().toArray(ImageReadoutParametersEvent.CcdType[]::new)).overRows(overRows.stream().mapToInt(i -> i).toArray()).overCols(overCols.stream().mapToInt(i -> i).toArray()).readRows(readRows.stream().mapToInt(i -> i).toArray()).readCols(readCols.stream().mapToInt(i -> i).toArray()).readCols2(readCols2.stream().mapToInt(i -> i).toArray()).preCols(preCols.stream().mapToInt(i -> i).toArray()).preRows(preRows.stream().mapToInt(i -> i).toArray()).postCols(postCols.stream().mapToInt(i -> i).toArray()).underCols(underCols.stream().mapToInt(i -> i).toArray()).daqFolder(data.getDaqFolder()).daqAnnotation(data.getAnnotation()).build();
                    this.ocsCommandExecutor.sendEvent((CameraEvent)irpe);
                } else if (ssd.getSubsystemData().getValue() instanceof ImageMetaDataEvent) {
                    ImageMetaDataEvent data = (ImageMetaDataEvent)ssd.getSubsystemData().getValue();
                    if (this.imageNameEvent == null) {
                        LOG.log(Level.WARNING, "Could not process ImageMetaDataEvent because of an imageNameEvent was not received.");
                    } else {
                        this.endOfImageTelemetryEvent = EndOfImageTelemetryEvent.builder().additionalKeys(DELIMITED_STRING_SPLIT_JOIN.join(this.imageNameEvent.getKeyValueData().keySet())).additionalValues(DELIMITED_STRING_SPLIT_JOIN.join(this.imageNameEvent.getKeyValueData().values())).imagesInSequence(this.imageNameEvent.getImagesInSequence()).imageIndex(this.imageNameEvent.getSequenceNumber() + 1).imageName(data.getImageName().toString()).imageSource(data.getImageName().getSource().getCode()).imageController(data.getImageName().getController().getCode()).imageDate(data.getImageName().getDateString()).imageNumber(data.getImageName().getNumber()).timestampAcquisitionStart(data.getLastClearTime().getTAIDouble()).timestampDateEnd(data.getIntegrationEndTime().getTAIDouble()).timestampDateObs(data.getIntegrationStartTime().getTAIDouble()).darkTime(data.getDarkTime()).imageTag(data.getDaqTag()).exposureTime(this.imageNameEvent.getExposureTime()).measuredShutterOpenTime(this.imageNameEvent.getExposureTime()).emulatedImage(data.getEmulatedImageName() == null ? "" : data.getEmulatedImageName()).build();
                    }
                } else if (ssd.getSubsystemData().getValue() instanceof List) {
                    this.telemetrySender.send(ssd);
                } else {
                    LOG.log(Level.WARNING, "Got unhandled telemetry from {0}", subsystemName);
                }
            }
        });
        ccs.addStateChangeListener((when, currentState, oldState, cause) -> {
            CameraStateChangeEvent converted = this.ocsCcsStateEventConverter.convert(when, currentState);
            if (converted == null) {
                LOG.log(Level.WARNING, "Enum {0} of class {1} could not be converted to equivalent OCS state", new Object[]{currentState, currentState.getClass()});
            } else {
                this.ocsCommandExecutor.sendEvent((CameraEvent)converted);
            }
        });
    }

    State<CCSCommandStateEvent.CCSCommandState> getCommandState() {
        return this.commandState;
    }

    public OCSBridgeConfig getConfig() {
        return this.config;
    }

    void addSubsystem(String subsystemName, DataProviderDictionary dict) {
        this.telemetrySender.getConverter().addSubsystem(subsystemName, dict);
        this.configurationSender.getConverter().addSubsystem(subsystemName, dict);
    }

    void removeSubsystem(String subsystemName) {
        this.telemetrySender.getConverter().removeSubsystem(subsystemName);
        this.configurationSender.getConverter().removeSubsystem(subsystemName);
    }

    void setOCSCommandExecutor(OCSCommandExecutor ocs) {
        this.ocsCommandExecutor = ocs;
        this.telemetrySender.setSender(ocs);
        this.configurationSender.setSender(ocs);
        CCSTimeStamp now = CCSTimeStamp.currentTime();
        this.ccs.getAggregateStatus().getStates().stream().map(s -> this.ocsCcsStateEventConverter.convert(now, (Enum)s.getState())).filter(Objects::nonNull).forEach(converted -> this.ocsCommandExecutor.sendEvent((CameraEvent)converted));
    }

    public OCSCommandExecutor getOcsCommandExecutor() {
        return this.ocsCommandExecutor;
    }

    void setCCSCommandExecutor(CCSCommandExecutor ccs) {
        this.ccsCommandExecutor = ccs;
    }

    public static void main(String[] args) {
        OCSBridge ocs = OCSBridge.createOCSBridge();
        ToyOCSGUI gui = new ToyOCSGUI(new GUIDirectLayer(ocs), ocs.getConfig().getDevice());
        gui.setVisible(true);
    }

    static OCSBridge createOCSBridge() {
        return OCSBridge.createOCSBridge(MCMConfig.createDefaultConfig());
    }

    static OCSBridge createOCSBridge(MCMConfig mcmConfig) {
        OCSBridgeConfig ocsConfig = OCSBridgeConfig.createDefaultConfig();
        ImageNameService ins = ImageNameService.testInstance((String)"jdbc:h2:mem:test;MODE=MYSQL", (Controller)Controller.OCS, (Source)Source.MainCamera, (String)"UTC", (Duration)Duration.ofHours(12L), (Instant)Instant.parse("2022-01-01T00:00:00.00Z"));
        return OCSBridge.createOCSBridge(ocsConfig, mcmConfig, ins);
    }

    static OCSBridge createOCSBridge(Camera camera) {
        OCSBridgeConfig ocsConfig = OCSBridgeConfig.createDefaultConfig();
        MCMConfig mcmConfig = new MCMConfig(camera);
        ImageNameService ins = ImageNameService.testInstance((String)"jdbc:h2:mem:test;MODE=MYSQL", (Controller)Controller.OCS, (Source)(camera == Camera.AUXTEL ? Source.AuxTel : Source.MainCamera), (String)"UTC", (Duration)Duration.ofHours(12L), (Instant)Instant.parse("2022-01-01T00:00:00.00Z"));
        return OCSBridge.createOCSBridge(ocsConfig, mcmConfig, ins);
    }

    static OCSBridge createOCSBridge(OCSBridgeConfig config, MCMConfig mcmConfig, ImageNameService imageNamingService) {
        CCS ccs = new CCS();
        MCMDirectLayer mcm = new MCMDirectLayer(new MCM(ccs, mcmConfig, imageNamingService));
        return new OCSBridge(config, ccs, mcm);
    }

    State getLse209State() {
        return this.lse209State;
    }

    State getOfflineState() {
        return this.offlineState;
    }

    private String makeSemverCompliant(int version) {
        return version + ".0.0";
    }

    void execute(CameraCommand cmd) {
        if (cmd instanceof DisableCommand) {
            this.execute((DisableCommand)cmd);
        } else if (cmd instanceof EnableCommand) {
            this.execute((EnableCommand)cmd);
        } else if (cmd instanceof ExitControlCommand) {
            this.execute((ExitControlCommand)cmd);
        } else if (cmd instanceof EnterControlCommand) {
            this.execute((EnterControlCommand)cmd);
        } else if (cmd instanceof TakeImagesCommand) {
            this.execute((TakeImagesCommand)cmd);
        } else if (cmd instanceof StartCommand) {
            this.execute((StartCommand)cmd);
        } else if (cmd instanceof StartImageCommand) {
            this.execute((StartImageCommand)cmd);
        } else if (cmd instanceof InitGuidersCommand) {
            this.execute((InitGuidersCommand)cmd);
        } else if (cmd instanceof StandbyCommand) {
            this.execute((StandbyCommand)cmd);
        } else if (!(cmd instanceof SetAuthListCommand)) {
            ForwardToMCMExecutor fcm = new ForwardToMCMExecutor(cmd);
            this.ocsCommandExecutor.executeCommand(fcm);
        }
    }

    void execute(InitGuidersCommand command) {
        InitGuidersExecutor initGuiders = new InitGuidersExecutor(command);
        this.ocsCommandExecutor.executeCommand(initGuiders);
    }

    void execute(TakeImagesCommand command) {
        TakeImagesExecutor takeImages = new TakeImagesExecutor(command);
        this.ocsCommandExecutor.executeCommand(takeImages);
    }

    void execute(StartImageCommand command) {
        StartImageExecutor startImage = new StartImageExecutor(command);
        this.ocsCommandExecutor.executeCommand(startImage);
    }

    void execute(EnterControlCommand command) {
        EnterControlExecutor takeControl = new EnterControlExecutor(command);
        this.ocsCommandExecutor.executeCommand(takeControl);
    }

    void execute(ExitControlCommand command) {
        ExitExecutor exit = new ExitExecutor(command);
        this.ocsCommandExecutor.executeCommand(exit);
    }

    void execute(StartCommand command) {
        StartExecutor start = new StartExecutor(command);
        this.ocsCommandExecutor.executeCommand(start);
    }

    void execute(StandbyCommand command) {
        StandbyExecutor standby = new StandbyExecutor(command);
        this.ocsCommandExecutor.executeCommand(standby);
    }

    void execute(EnableCommand command) {
        EnableExecutor enable = new EnableExecutor(command);
        this.ocsCommandExecutor.executeCommand(enable);
    }

    void execute(DisableCommand command) {
        DisableExecutor disable = new DisableExecutor(command);
        this.ocsCommandExecutor.executeCommand(disable);
    }

    void execute(CCSCommand command) {
        if (command instanceof CCSCommand.CCSSetAvailableCommand) {
            this.execute((CCSCommand.CCSSetAvailableCommand)command);
        } else if (command instanceof CCSCommand.CCSRevokeAvailableCommand) {
            this.execute((CCSCommand.CCSRevokeAvailableCommand)command);
        } else if (command instanceof CCSCommand.CCSSimulateFaultCommand) {
            this.execute((CCSCommand.CCSSimulateFaultCommand)command);
        } else if (command instanceof CCSCommand.CCSClearFaultCommand) {
            this.execute((CCSCommand.CCSClearFaultCommand)command);
        } else {
            throw new RuntimeException("Unknown command type: " + command);
        }
    }

    void execute(CCSCommand.CCSSetAvailableCommand command) {
        SetAvailableExecutor setAvailable = new SetAvailableExecutor(command);
        this.ccsCommandExecutor.executeCommand(new CCSCommand.CCSCommandResponse<Void>(setAvailable));
    }

    void execute(CCSCommand.CCSRevokeAvailableCommand command) {
        RevokeAvailableExecutor revokeAvailable = new RevokeAvailableExecutor(command);
        this.ccsCommandExecutor.executeCommand(new CCSCommand.CCSCommandResponse<Void>(revokeAvailable));
    }

    void execute(CCSCommand.CCSSimulateFaultCommand command) {
        SimulateFaultExecutor simulateFault = new SimulateFaultExecutor(command);
        this.ccsCommandExecutor.executeCommand(new CCSCommand.CCSCommandResponse<Void>(simulateFault));
    }

    void execute(CCSCommand.CCSClearFaultCommand command) {
        ClearFaultExecutor clearFault = new ClearFaultExecutor(command);
        this.ccsCommandExecutor.executeCommand(new CCSCommand.CCSCommandResponse<Void>(clearFault));
    }

    public Future<Void> waitForState(Enum state) {
        return this.ccs.waitForStatus(state);
    }

    CCS getCCS() {
        return this.ccs;
    }

    class ClearFaultExecutor
    extends CCSExecutor {
        private ClearFaultExecutor(CCSCommand.CCSClearFaultCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.FAULT)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws Exception {
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.OFFLINE);
            OCSBridge.this.offlineState.setState(OfflineDetailedStateEvent.OfflineState.OFFLINE_PUBLISH_ONLY);
        }
    }

    class SimulateFaultExecutor
    extends CCSExecutor {
        private SimulateFaultExecutor(CCSCommand.CCSSimulateFaultCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws Exception {
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.FAULT);
        }
    }

    class RevokeAvailableExecutor
    extends CCSExecutor {
        private RevokeAvailableExecutor(CCSCommand.CCSRevokeAvailableCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.OFFLINE)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            if (!OCSBridge.this.offlineState.isInState(OfflineDetailedStateEvent.OfflineState.OFFLINE_AVAILABLE)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Command not accepted in " + OCSBridge.this.offlineState);
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws Exception {
            OCSBridge.this.offlineState.setState(OfflineDetailedStateEvent.OfflineState.OFFLINE_PUBLISH_ONLY);
        }
    }

    class SetAvailableExecutor
    extends CCSExecutor {
        private SetAvailableExecutor(CCSCommand.CCSSetAvailableCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.OFFLINE)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            if (!OCSBridge.this.offlineState.isInState(OfflineDetailedStateEvent.OfflineState.OFFLINE_PUBLISH_ONLY)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Command not accepted in " + OCSBridge.this.offlineState);
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws Exception {
            OCSBridge.this.offlineState.setState(OfflineDetailedStateEvent.OfflineState.OFFLINE_AVAILABLE);
        }
    }

    class DisableExecutor
    extends OCSCommandExecutor.OCSExecutor {
        public DisableExecutor(DisableCommand command) {
            super((CameraCommand)command);
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.ENABLED)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            return Duration.ZERO;
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.DISABLED);
        }
    }

    class EnableExecutor
    extends OCSCommandExecutor.OCSExecutor {
        public EnableExecutor(EnableCommand command) {
            super((CameraCommand)command);
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.DISABLED)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            return Duration.ZERO;
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.ENABLED);
        }
    }

    class StandbyExecutor
    extends ForwardToMCMExecutor {
        public StandbyExecutor(StandbyCommand command) {
            super((CameraCommand)command, SummaryStateEvent.SummaryState.DISABLED);
        }

        @Override
        void execute() throws Exception {
            super.execute();
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.STANDBY);
        }
    }

    class StartExecutor
    extends ForwardToMCMExecutor {
        public StartExecutor(StartCommand command) {
            super((CameraCommand)command, SummaryStateEvent.SummaryState.STANDBY);
        }

        @Override
        void execute() throws Exception {
            super.execute();
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.DISABLED);
        }
    }

    class ExitExecutor
    extends OCSCommandExecutor.OCSExecutor {
        public ExitExecutor(ExitControlCommand command) {
            super((CameraCommand)command);
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.STANDBY)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            return Duration.ZERO;
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.mcm.unlock();
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.OFFLINE);
            OCSBridge.this.offlineState.setState(OfflineDetailedStateEvent.OfflineState.OFFLINE_PUBLISH_ONLY);
        }
    }

    class EnterControlExecutor
    extends OCSCommandExecutor.OCSExecutor {
        public EnterControlExecutor(EnterControlCommand command) {
            super((CameraCommand)command);
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.OFFLINE)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            if (!OCSBridge.this.offlineState.isInState(OfflineDetailedStateEvent.OfflineState.OFFLINE_AVAILABLE)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.offlineState);
            }
            return Duration.ZERO;
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.mcm.lock();
            CCSCommand.CCSCommandResponse response = OCSBridge.this.mcm.execute(new CCSCommand.CCSStandbyCommand());
            CCSCommand.CCSAckOrNack ackOrNack = response.waitForAckOrNack();
            if (ackOrNack.isNack()) {
                throw new RuntimeException("Standby command rejected: " + ackOrNack.getReason());
            }
            response.waitForCompletion();
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.STANDBY);
        }
    }

    class StartImageExecutor
    extends ForwardToMCMExecutor {
        public StartImageExecutor(StartImageCommand command) {
            super((CameraCommand)command);
        }

        @Override
        protected CCSCommand.CCSAckOrNack forwardCommand() {
            OCSBridge.this.imageNameTransfer.clear();
            return super.forwardCommand();
        }
    }

    class TakeImagesExecutor
    extends ForwardToMCMExecutor {
        public TakeImagesExecutor(TakeImagesCommand command) {
            super((CameraCommand)command);
        }

        @Override
        protected CCSCommand.CCSAckOrNack forwardCommand() {
            OCSBridge.this.imageNameTransfer.clear();
            return super.forwardCommand();
        }
    }

    class InitGuidersExecutor
    extends ForwardToMCMExecutor {
        public InitGuidersExecutor(InitGuidersCommand command) {
            super((CameraCommand)command);
        }
    }

    class ForwardToMCMExecutor
    extends OCSCommandExecutor.OCSExecutor {
        private CCSCommand.CCSCommandResponse response;
        private final SummaryStateEvent.SummaryState initialState;
        private final CameraCommand command;
        private CCSCommand ccsCommand;

        ForwardToMCMExecutor(CameraCommand command) {
            this(command, SummaryStateEvent.SummaryState.ENABLED);
        }

        ForwardToMCMExecutor(CameraCommand command, SummaryStateEvent.SummaryState initialState) {
            super(command);
            this.command = command;
            this.initialState = initialState;
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(this.initialState)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in: " + OCSBridge.this.lse209State);
            }
            try {
                this.ccsCommand = OCSBridge.this.ocsCcsCommandConverter.convert(this.command);
                CCSCommand.CCSAckOrNack can = this.forwardCommand();
                if (can.isNack()) {
                    throw new OCSCommandExecutor.PreconditionsNotMet("Command rejected: " + can.getReason());
                }
                return can.getDuration();
            }
            catch (OCSCommandConverter.CommandConversionException x) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command rejected: " + x.getMessage());
            }
        }

        protected CCSCommand.CCSAckOrNack forwardCommand() {
            this.response = OCSBridge.this.mcm.execute(this.ccsCommand);
            return this.response.waitForAckOrNack();
        }

        @Override
        void execute() throws Exception {
            this.response.waitForCompletion();
        }
    }
}

