/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.demo.main.device;

import java.time.Duration;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.demo.DemoDriver;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.DataProviderDictionaryService;

public class OtherDevice
extends Device {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private DataProviderDictionaryService dataProviderDictionaryService;
    private DemoDriver driver;
    private final String id;
    private final Random r = new Random();
    private int meta;
    @LookupPath
    private String path;

    public OtherDevice(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void build() {
        ((AgentPeriodicTaskService)this.s.getAgentService(AgentPeriodicTaskService.class)).scheduleAgentPeriodicTask(new AgentPeriodicTask(this.path + "-update-metadata", () -> {
            this.meta += 2;
            this.dataProviderDictionaryService.publishMetadataForObject("devicemetadata", String.valueOf(this.meta), (Object)this);
        }).withPeriod(Duration.ofSeconds(-1L)));
    }

    protected void initialize() {
        if (this.driver == null) {
            try {
                this.driver = new DemoDriver();
            }
            catch (DriverException ex) {
                Logger.getLogger(OtherDevice.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
        }
        this.setOnline(true);
    }

    protected void close() {
        if (this.driver != null) {
            try {
                this.driver.close();
                this.driver = null;
            }
            catch (DriverException ex) {
                Logger.getLogger(OtherDevice.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
        }
    }

    protected double readChannel(int chan, int type) {
        return (double)chan + this.r.nextGaussian();
    }
}

