/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.util.DelimitedStringSplitJoin;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.command.ClearCommand;
import org.lsst.sal.camera.command.DisableCalibrationCommand;
import org.lsst.sal.camera.command.DiscardRowsCommand;
import org.lsst.sal.camera.command.EnableCalibrationCommand;
import org.lsst.sal.camera.command.EndImageCommand;
import org.lsst.sal.camera.command.InitGuidersCommand;
import org.lsst.sal.camera.command.InitImageCommand;
import org.lsst.sal.camera.command.PlayCommand;
import org.lsst.sal.camera.command.PlaylistCommand;
import org.lsst.sal.camera.command.SetFilterCommand;
import org.lsst.sal.camera.command.StandbyCommand;
import org.lsst.sal.camera.command.StartCommand;
import org.lsst.sal.camera.command.StartImageCommand;
import org.lsst.sal.camera.command.TakeImagesCommand;

public class OCSCommandConverter {
    private final Map<Class<? extends CameraCommand>, Class<? extends CCSCommand>> ocsToCcsCommandMap;
    private final DelimitedStringSplitJoin delimitedStringSplitJoin = new DelimitedStringSplitJoin();

    public OCSCommandConverter() {
        this.ocsToCcsCommandMap = new HashMap<Class<? extends CameraCommand>, Class<? extends CCSCommand>>();
        this.ocsToCcsCommandMap.put(SetFilterCommand.class, CCSCommand.CCSSetFilterCommand.class);
        this.ocsToCcsCommandMap.put(ClearCommand.class, CCSCommand.CCSClearCommand.class);
        this.ocsToCcsCommandMap.put(EndImageCommand.class, CCSCommand.CCSEndImageCommand.class);
        this.ocsToCcsCommandMap.put(InitGuidersCommand.class, CCSCommand.CCSInitGuidersCommand.class);
        this.ocsToCcsCommandMap.put(StartImageCommand.class, CCSCommand.CCSStartImageCommand.class);
        this.ocsToCcsCommandMap.put(TakeImagesCommand.class, CCSCommand.CCSTakeImagesCommand.class);
        this.ocsToCcsCommandMap.put(StartCommand.class, CCSCommand.CCSStartCommand.class);
        this.ocsToCcsCommandMap.put(StandbyCommand.class, CCSCommand.CCSStandbyCommand.class);
        this.ocsToCcsCommandMap.put(DisableCalibrationCommand.class, CCSCommand.CCSDisableCalibrationCommand.class);
        this.ocsToCcsCommandMap.put(DiscardRowsCommand.class, CCSCommand.CCSDiscardRowsCommand.class);
        this.ocsToCcsCommandMap.put(InitImageCommand.class, CCSCommand.CCSInitImageCommand.class);
        this.ocsToCcsCommandMap.put(EnableCalibrationCommand.class, CCSCommand.CCSEnableCalibrationCommand.class);
        this.ocsToCcsCommandMap.put(PlayCommand.class, CCSCommand.CCSPlayCommand.class);
        this.ocsToCcsCommandMap.put(PlaylistCommand.class, CCSCommand.CCSDefinePlaylistCommand.class);
    }

    public CCSCommand convert(CameraCommand myOCSCommand) throws CommandConversionException {
        Class<? extends CCSCommand> ccsCommandFromMap = this.ocsToCcsCommandMap.get(((Object)((Object)myOCSCommand)).getClass());
        if (ccsCommandFromMap == null) {
            throw new CommandConversionException("Unsupported command " + ((Object)((Object)myOCSCommand)).toString());
        }
        try {
            CCSCommand ccsCommand = ccsCommandFromMap.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Field[] ocsCommandFields = ((Object)((Object)myOCSCommand)).getClass().getDeclaredFields();
            Field[] ccsCommandFields = ccsCommand.getClass().getDeclaredFields();
            for (Field ocsCommandField : ocsCommandFields) {
                if (ocsCommandField.isSynthetic()) continue;
                ocsCommandField.setAccessible(true);
                boolean matchFound = false;
                for (Field ccsCommandField : ccsCommandFields) {
                    if (ccsCommandField.isSynthetic()) continue;
                    ccsCommandField.setAccessible(true);
                    if (!ocsCommandField.getName().equals(ccsCommandField.getName())) continue;
                    if (!ocsCommandField.getType().equals(ccsCommandField.getType())) {
                        if (ocsCommandField.getType() == String.class && ccsCommandField.getType() == String[].class) {
                            ccsCommandField.set(ccsCommand, this.delimitedStringSplitJoin.split((String)ocsCommandField.get((Object)myOCSCommand)));
                            matchFound = true;
                            break;
                        }
                        throw new CommandConversionException("OCSCommandConverter: OCS and CCS Commands contain the same variable names with different types");
                    }
                    ccsCommandField.set(ccsCommand, ocsCommandField.get((Object)myOCSCommand));
                    matchFound = true;
                    break;
                }
                if (matchFound) continue;
                throw new CommandConversionException("OCSCommandCoverter : no match found between OCS CCS fields, OCSCommand:  " + ((Object)((Object)myOCSCommand)).toString() + " CCSCommand : " + ccsCommand.toString() + " for field " + ocsCommandField.getName());
            }
            return ccsCommand;
        }
        catch (ReflectiveOperationException ex) {
            throw new CommandConversionException("Error converting command : ", ex);
        }
    }

    public static class CommandConversionException
    extends Exception {
        private CommandConversionException(String msg) {
            super(msg);
        }

        private CommandConversionException(String msg, Throwable t) {
            super(msg, t);
        }
    }
}

