/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.bonnshutter;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.bonnshutter.BonnShutter;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.bonnshutter.BonnDevice;
import org.lsst.ccs.subsystem.bonnshutter.states.ShutterState;

public class BonnShutterSubsystem
extends Subsystem
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(BonnShutterSubsystem.class.getName());
    private BonnShutter shutter;
    @ConfigurationParameter(category="General", units="s", description="minimum exposure time")
    private volatile double minExposureTime = 0.1;
    @ConfigurationParameter(category="General", units="s", description="maximum exposure time")
    private volatile double maxExposureTime = 3600.0;
    @ConfigurationParameter(category="General", units="ms", description="added waitForExposure time")
    private volatile int openCloseTimeMillis = 1000;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private BonnDevice device;
    private Duration lastExposureTime;

    public BonnShutterSubsystem() {
        super("bonnsub", AgentInfo.AgentType.WORKER);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    public void init() {
        this.shutter = this.device.getShutter();
        this.agentStateService.registerState(ShutterState.class, "Bonn Shutter State", (Object)this);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Performs a shutter motion calibration")
    public void calibrate() {
        throw new UnsupportedOperationException("calibrate no timplemented");
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Closes the shutter", autoAck=false)
    public void closeShutter() {
        this.helper().precondition(this.agentStateService.isInState((Enum)ShutterState.OPEN) || this.agentStateService.isInState((Enum)ShutterState.UNKNOWN), "Shutter is not open", new Object[0]).enterFaultOnException(true).action(() -> this.shutter.closeShutter());
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Opens the shutter", autoAck=false)
    public void openShutter() throws DriverException {
        this.helper().precondition(this.agentStateService.isInState((Enum)ShutterState.CLOSED), "Shutter is not closed", new Object[0]).enterFaultOnException(true).action(() -> this.shutter.openShutter());
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Performs a timed exposure (open, wait, close)", autoAck=false)
    public void takeExposure(@Argument(name="exposureTime", description="The duration of the exposure in seconds") double exposureTime) {
        this.helper().precondition(exposureTime >= this.minExposureTime, "Exposure time (%5g) below min (%5g)", new Object[]{exposureTime, this.minExposureTime}).precondition(exposureTime <= this.maxExposureTime, "Exposure time (%5g) above max (%5g)", new Object[]{exposureTime, this.maxExposureTime}).precondition(this.agentStateService.isInState((Enum)ShutterState.CLOSED), "Shutter is not closed", new Object[0]).enterFaultOnException(true).action(() -> {
            this.shutter.expose((int)(exposureTime * 1000.0));
            boolean ok = this.agentStateService.waitFor(t -> !t.isInState((Enum)ShutterState.CLOSED), 1L, TimeUnit.SECONDS);
            if (!ok) {
                throw new TimeoutException("Timed out while waiting for shutter to start opening");
            }
            this.lastExposureTime = Duration.ofSeconds((long)Math.ceil(exposureTime));
        });
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Wait until exposure complete", autoAck=false)
    public void waitForExposure() throws InterruptedException {
        this.helper().precondition(this.lastExposureTime != null, "No exposure in progress", new Object[0]).duration(this.lastExposureTime).enterFaultOnException(true).action(() -> {
            boolean ok = this.agentStateService.waitFor(t -> t.isInState((Enum)ShutterState.CLOSED), this.lastExposureTime.toMillis() + (long)this.openCloseTimeMillis, TimeUnit.MILLISECONDS);
            this.lastExposureTime = null;
            if (!ok) {
                throw new TimeoutException("Timed out while waiting for shutter to close");
            }
        });
    }
}

