/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class ConfigurationAppliedEvent
extends CameraEvent {
    private final String configurations;
    private final String version;
    private final String url;
    private final String schemaVersion;
    private final String otherInfo;

    public ConfigurationAppliedEvent(int priority, String configurations, String version, String url, String schemaVersion, String otherInfo) {
        super(priority);
        this.configurations = configurations;
        this.version = version;
        this.url = url;
        this.schemaVersion = schemaVersion;
        this.otherInfo = otherInfo;
    }

    public String getConfigurations() {
        return this.configurations;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public String getOtherInfo() {
        return this.otherInfo;
    }

    public String toString() {
        return "ConfigurationAppliedEvent{configurations=" + this.configurations + ", version=" + this.version + ", url=" + this.url + ", schemaVersion=" + this.schemaVersion + ", otherInfo=" + this.otherInfo + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int priority;
        private String configurations;
        private String version;
        private String url;
        private String schemaVersion;
        private String otherInfo;

        private Builder() {
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder configurations(String configurations) {
            this.configurations = configurations;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public Builder otherInfo(String otherInfo) {
            this.otherInfo = otherInfo;
            return this;
        }

        public ConfigurationAppliedEvent build() {
            return new ConfigurationAppliedEvent(this.priority, this.configurations, this.version, this.url, this.schemaVersion, this.otherInfo);
        }
    }
}

