/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.util;

import com.ifountain.opsgenie.client.http.DefaultOpsgenieRequestRetryHandler;
import com.ifountain.opsgenie.client.http.OpsgenieRequestRetryHandler;
import com.ifountain.opsgenie.client.util.ClientProxyConfiguration;
import com.ifountain.opsgenie.client.util.ManifestUtils;
import java.util.List;
import java.util.jar.Manifest;
import org.apache.http.auth.Credentials;

public class ClientConfiguration {
    private ClientProxyConfiguration clientProxyConfiguration;
    private static String staticUserAgent;
    private List<Integer> httpsPorts;
    private int maxConnections = 50;
    private int socketTimeout = 50000;
    private Credentials credentials = null;
    private int connectionTimeout = 50000;
    private int socketSendBufferSizeHint = 0;
    private int socketReceiveBufferSizeHint = 0;
    private String userAgent = ClientConfiguration.initializeUserAgent();
    private OpsgenieRequestRetryHandler retryHandler = new DefaultOpsgenieRequestRetryHandler();

    public List<Integer> getHttpsPorts() {
        return this.httpsPorts;
    }

    public ClientConfiguration setHttpsPorts(List<Integer> httpsPorts) {
        this.httpsPorts = httpsPorts;
        return this;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public ClientConfiguration setCredentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public ClientConfiguration setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public ClientConfiguration setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public ClientConfiguration setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public ClientConfiguration setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public int getSocketSendBufferSizeHint() {
        return this.socketSendBufferSizeHint;
    }

    public ClientConfiguration setSocketSendBufferSizeHint(int socketSendBufferSizeHint) {
        this.socketSendBufferSizeHint = socketSendBufferSizeHint;
        return this;
    }

    public int getSocketReceiveBufferSizeHint() {
        return this.socketReceiveBufferSizeHint;
    }

    public ClientConfiguration setSocketReceiveBufferSizeHint(int socketReceiveBufferSizeHint) {
        this.socketReceiveBufferSizeHint = socketReceiveBufferSizeHint;
        return this;
    }

    public OpsgenieRequestRetryHandler getRetryHandler() {
        return this.retryHandler;
    }

    public ClientConfiguration setRetryHandler(OpsgenieRequestRetryHandler retryHandler) {
        this.retryHandler = retryHandler;
        return this;
    }

    public ClientProxyConfiguration getClientProxyConfiguration() {
        return this.clientProxyConfiguration;
    }

    public ClientConfiguration setClientProxyConfiguration(ClientProxyConfiguration clientProxyConfiguration) {
        this.clientProxyConfiguration = clientProxyConfiguration;
        return this;
    }

    private static String initializeUserAgent() {
        if (staticUserAgent == null) {
            staticUserAgent = ClientConfiguration.createUserAgentFromManifest(ClientConfiguration.class);
        }
        return staticUserAgent;
    }

    public static String createUserAgentFromManifest(Class manifestFileClass) {
        Manifest manifest = ManifestUtils.loadManifest(manifestFileClass);
        String sdkVersion = manifest.getMainAttributes().getValue("Implementation-Version");
        String sdkProductName = manifest.getMainAttributes().getValue("Implementation-Product");
        if (sdkVersion == null) {
            sdkVersion = "1.0";
        }
        if (sdkProductName == null) {
            sdkProductName = "opsgenie-sdk-java";
        }
        return ClientConfiguration.createUserAgent(String.valueOf(sdkProductName), String.valueOf(sdkVersion));
    }

    public static String createUserAgent(String agentName, String agentVersion) {
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append(agentName).append("/").append(agentVersion);
        buffer.append(" (");
        buffer.append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version"));
        buffer.append("; ");
        buffer.append(System.getProperty("java.vm.name")).append(" ").append(System.getProperty("java.vm.version"));
        if (System.getProperty("user.language") != null) {
            buffer.append("; ").append(System.getProperty("user.language"));
        }
        if (System.getProperty("user.region") != null) {
            buffer.append("; ").append(System.getProperty("user.region"));
        }
        buffer.append(")");
        return buffer.toString();
    }
}

