/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mmm;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import org.lsst.ccs.Agent;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.StatusEnum;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.mmm.AlertDispatcher;
import org.lsst.ccs.subsystem.mmm.AlertNotification;
import org.lsst.ccs.subsystem.mmm.MMMUtilities;
import org.lsst.ccs.subsystem.mmm.Minion;
import org.lsst.ccs.subsystem.mmm.MinionGroup;
import org.lsst.ccs.subsystem.mmm.data.MMMIR2Event;
import org.lsst.ccs.utilities.logging.Logger;

public class GenericMMM
extends Subsystem
implements HasLifecycle {
    protected MMMUtilities mu;
    @ConfigurationParameter(isFinal=true, maxLength=20)
    protected final Map<MinionGroup, Map<String, Minion>> minions = new HashMap<MinionGroup, Map<String, Minion>>();
    @LookupField(strategy=LookupField.Strategy.TOP)
    Subsystem subsystem;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected Map<String, AlertDispatcher> dispatchers = new HashMap<String, AlertDispatcher>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    AgentStateService agentStateService;
    protected Random random = new Random();
    protected static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.mmm");

    public void init() {
        this.mu = new MMMUtilities((Agent)this.subsystem);
        for (Map.Entry<MinionGroup, Map<String, Minion>> e : this.minions.entrySet()) {
            MinionGroup group = e.getKey();
            for (Map.Entry<String, Minion> e1 : e.getValue().entrySet()) {
                this.mu.addMinion(group, e1.getValue(), e1.getKey());
            }
        }
        ((AgentCommandDictionaryService)this.subsystem.getAgentService(AgentCommandDictionaryService.class)).addCommandSetToObject((Object)this.mu, (Object)this.subsystem);
        this.mu.init();
    }

    public void start() {
        this.mu.start();
        this.mu.addAlertObserver(this::onAlert);
        this.mu.activate();
    }

    protected MMMUtilities getMmmUtilities() {
        return this.mu;
    }

    public GenericMMM() {
        this("genericMMM");
    }

    public GenericMMM(String name) {
        super(name, AgentInfo.AgentType.MMM);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    public void onAlert(AlertNotification notif) {
        log.warn((Object)(notif + " " + notif.getOrigin() + " " + notif.getSubsystemType() + " " + notif.getSubsystemGroup()));
        for (Map.Entry<String, AlertDispatcher> e : this.dispatchers.entrySet()) {
            AlertDispatcher ad = e.getValue();
            boolean affectsDispatcher = false;
            if (notif.getOrigin().equals(this.subsystem.getName())) {
                String group = (String)notif.getAlert().getAlertData("group");
                if (ad.getGroupName().equals(group)) {
                    affectsDispatcher = true;
                }
            }
            if (!affectsDispatcher && !ad.getGroup().equals(notif.getSubsystemGroup())) continue;
            e.getValue().onAlert(notif);
        }
    }

    @Command
    public String[] getAlertDispatchers() {
        return this.dispatchers.keySet().toArray(new String[0]);
    }

    @Command
    public String status() {
        StringBuilder sb = new StringBuilder();
        sb.append("Dispatchers: \n");
        for (Map.Entry<String, AlertDispatcher> e : this.dispatchers.entrySet()) {
            sb.append("\n");
            sb.append(e.getValue().status("\t"));
        }
        return sb.toString();
    }

    public void publishEvent(MMMIR2Event e) {
        StatusEnum message = new StatusEnum((Enum)e, this.stateService.getState());
        this.subsystem.getMessagingAccess().sendStatusMessage((StatusMessage)message);
    }

    public Object send(MinionGroup g, Minion dst, String command, Object ... parms) throws Exception {
        return this.mu.send(g, dst, command, parms);
    }

    public Object sendLongCommand(MinionGroup g, Minion dst, long duration, String command, Object ... parms) throws Exception {
        return this.mu.sendLongCommand(g, dst, duration, command, parms);
    }

    public Future<Object> sendAsync(MinionGroup g, Minion dst, String command, Object ... parms) {
        return this.mu.sendAsync(g, dst, command, parms);
    }

    public <MinionMMMIR2State extends Enum<MinionMMMIR2State>> Future<StatusMessage> watchForState(MinionGroup g, Minion sys, MinionMMMIR2State state) {
        return this.mu.watchForState(g, sys, state);
    }

    public <MinionMMMIR2State extends Enum<MinionMMMIR2State>> void waitForState(MinionGroup g, Minion sys, MinionMMMIR2State state, long timeout) {
        this.mu.waitForState(g, sys, state, timeout);
    }

    public void waitMillis(long millis) {
        this.mu.waitMillis(millis);
    }

    public <MinionMMMIR2State extends Enum<MinionMMMIR2State>> void checkState(MinionGroup g, Minion sys, MinionMMMIR2State state) {
        this.mu.checkState(g, sys, state);
    }

    @SafeVarargs
    public final <MinionMMMIR2State extends Enum<MinionMMMIR2State>> void checkState(MinionGroup g, Minion sys, MinionMMMIR2State ... state) {
        this.mu.checkState(g, sys, state);
    }

    public <MMMIR2State extends Enum<MMMIR2State>> MMMUtilities.ExpectedStateCombination<MMMIR2State> expectingState(MinionGroup g, Minion m, MMMIR2State state) {
        return this.mu.expectingState(g, m, state);
    }

    @SafeVarargs
    public final void setAbortingOnAlarmMinions(MinionGroup g, Minion ... m) {
        this.mu.setAbortingOnAlarmMinions(g, m);
    }

    public ScheduledFuture<?> schedule(Runnable r, Duration delay) {
        return this.mu.schedule(r, delay);
    }

    public Future<?> execute(Runnable r) {
        return this.mu.execute(r);
    }
}

