/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.constants;

import org.lsst.ccs.bus.data.Alert;

public enum ThermalAlert {
    COLD_TEMP_HIGH("ColdTempHigh", "Cold-plate temperature high"),
    COLD_COMP_OFF("ColdCompOff", "Cold compressors off"),
    COLD_MINUS_TEMP_LOW("ColdMinusTempLow", "Cold-plate minus-end temperature low"),
    COLD_CENTER_TEMP_LOW("ColdCenterTempLow", "Cold-plate center temperature low"),
    COLD_PLUS_TEMP_LOW("ColdPlusTempLow", "Cold-plate plus-end temperature low"),
    CRYO_TEMP_LOW("CryoTempLow", "Cryo-plate temperature low");

    private final String id;
    private final String description;

    private ThermalAlert(String id, String description) {
        this.id = id;
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public Alert newAlert() {
        return new Alert(this.id, this.description);
    }
}

