/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.agilent;

import java.io.BufferedReader;
import java.io.FileReader;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.agilent.Device;

public class DeviceTestShell {
    private Device mydev;

    public DeviceTestShell() {
        try {
            this.mydev = new Device();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Command(description="Open device for use\nopen [channelNumber] [powerSeq] [voltage] [currlm]")
    public String open(int channelNumber, int powerSeq, double voltage, double currlimt) throws Exception {
        try {
            this.mydev.init("127.0.0.1", channelNumber, powerSeq, voltage, currlimt);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return "Good";
    }

    @Command(description="Open config file and connection to power supply\nload [filename] [hostname]")
    public String load(String fname, String hostname) throws Exception {
        String str;
        BufferedReader in = null;
        int chanNum = 0;
        int powerSeq = 0;
        double setVolt = 0.0;
        double setCurrLimit = 0.0;
        try {
            in = new BufferedReader(new FileReader(fname));
        }
        catch (Exception e) {
            return e.getMessage();
        }
        while ((str = in.readLine()) != null) {
            if (str.charAt(0) == '#') continue;
            str = str.replaceAll("\\s+", "");
            String[] strArr = str.split(",");
            System.out.println(str);
            if (strArr.length != 4) continue;
            chanNum = Integer.parseInt(strArr[0]);
            setVolt = Double.parseDouble(strArr[1]);
            setCurrLimit = Double.parseDouble(strArr[2]);
            powerSeq = Integer.parseInt(strArr[3]);
            try {
                this.mydev.init(hostname, chanNum, powerSeq, setVolt, setCurrLimit);
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        in.close();
        return "OK";
    }

    @Command(description="Set voltage, current limit in the proper order.")
    public String powerOn() throws Exception {
        try {
            this.mydev.powerOn();
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return "Good";
    }

    @Command(description="Power off channels")
    public String powerOff() throws Exception {
        try {
            this.mydev.powerOff();
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return "Good";
    }

    @Command(description="Return readback voltage from a channel\nchanVoltage [channel]")
    public String chanVoltage(int channel) throws Exception {
        String ret = "";
        try {
            ret = Double.toString(this.mydev.chanVoltage(channel));
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return ret;
    }

    static String toHex(byte[] digest) {
        String digits = "0123456789abcdef";
        StringBuilder sb = new StringBuilder(digest.length * 2);
        for (byte b : digest) {
            int bi = b & 0xFF;
            sb.append(digits.charAt(bi >> 4));
            sb.append(digits.charAt(bi & 0xF));
        }
        return sb.toString();
    }
}

