/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.power.data.PowerChanState;

public class PowerStatusPanel
extends JPanel {
    private static final Map<Integer, String> pStateMap = new HashMap<Integer, String>();
    private static final Map<Integer, Color> pColorMap;
    private final JPanel pwrStPanel = new JPanel();
    private final JLabel lbPsName = new JLabel("Power Status: ");
    private final JLabel lbPsValue = new JLabel();
    private final JLabel lbPwrHdrState = new JLabel("State");
    private final JLabel lbPwrHdrVoltage = new JLabel("Voltage");
    private final JLabel lbPwrHdrCurrent = new JLabel("Current");
    private JLabel[] lbPwrName = new JLabel[0];
    private JLabel[] lbPwrState;
    private JLabel[] lbPwrVoltage;
    private JLabel[] lbPwrCurrent;
    private final Parent parent;
    private static final long serialVersionUID = 1L;

    public PowerStatusPanel(Parent parent) {
        this.parent = parent;
        this.initPowerPanel();
    }

    public void updatePanel(List<PowerChanState> power) {
        this.lbPsValue.setText("RUNNING");
        this.lbPsValue.setForeground(UiConstants.GREEN);
        this.updatePower(power);
    }

    public void disablePanel() {
        this.lbPsValue.setText("STOPPED");
        this.lbPsValue.setForeground(UiConstants.RED);
    }

    private void initPowerPanel() {
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 4;
        this.pwrStPanel.add(this.lbPsName);
        this.lbPsValue.setText("STOPPED");
        this.lbPsValue.setForeground(UiConstants.RED);
        this.pwrStPanel.add(this.lbPsValue);
        this.add((Component)this.pwrStPanel, gbc);
        gbc.insets = new Insets(5, 10, 5, 10);
        gbc.anchor = 13;
        gbc.gridwidth = 1;
        gbc.gridx = 1;
        ++gbc.gridy;
        this.add((Component)this.lbPwrHdrState, gbc);
        ++gbc.gridx;
        this.add((Component)this.lbPwrHdrVoltage, gbc);
        ++gbc.gridx;
        this.add((Component)this.lbPwrHdrCurrent, gbc);
    }

    private void updatePower(List<PowerChanState> power) {
        if (power.size() == this.lbPwrName.length) {
            this.updatePwrPanel(power);
        } else {
            this.resizePwrPanel(power);
            this.parent.powerResized();
        }
    }

    private void updatePwrPanel(List<PowerChanState> power) {
        for (int j = 0; j < power.size(); ++j) {
            PowerChanState pwr = power.get(j);
            this.lbPwrName[j].setText(pwr.getName() + ":");
            this.lbPwrState[j].setText(pStateMap.get(pwr.getState()));
            this.lbPwrState[j].setForeground(pColorMap.get(pwr.getState()));
            this.lbPwrVoltage[j].setText(String.format("%.3f", pwr.getVoltage()));
            this.lbPwrCurrent[j].setText(String.format("%.3f", pwr.getCurrent()));
        }
    }

    private void resizePwrPanel(List<PowerChanState> power) {
        int nChan = power.size();
        for (int j = 0; j < this.lbPwrName.length; ++j) {
            this.remove(this.lbPwrName[j]);
            this.remove(this.lbPwrState[j]);
            this.remove(this.lbPwrVoltage[j]);
            this.remove(this.lbPwrCurrent[j]);
        }
        this.lbPwrName = new JLabel[nChan];
        this.lbPwrState = new JLabel[nChan];
        this.lbPwrVoltage = new JLabel[nChan];
        this.lbPwrCurrent = new JLabel[nChan];
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 10, 5, 10);
        gbc.anchor = 13;
        gbc.gridwidth = 1;
        gbc.gridx = 1;
        gbc.gridy = 2;
        for (int j = 0; j < nChan; ++j) {
            PowerChanState pwr = power.get(j);
            ++gbc.gridy;
            gbc.gridx = 0;
            this.lbPwrName[j] = new JLabel(pwr.getName() + ":");
            this.add((Component)this.lbPwrName[j], gbc);
            ++gbc.gridx;
            this.lbPwrState[j] = new JLabel(pStateMap.get(pwr.getState()));
            this.lbPwrState[j].setForeground(pColorMap.get(pwr.getState()));
            this.add((Component)this.lbPwrState[j], gbc);
            ++gbc.gridx;
            this.lbPwrVoltage[j] = new JLabel(String.format("%.3f", pwr.getVoltage()));
            this.add((Component)this.lbPwrVoltage[j], gbc);
            ++gbc.gridx;
            this.lbPwrCurrent[j] = new JLabel(String.format("%.3f", pwr.getCurrent()));
            this.add((Component)this.lbPwrCurrent[j], gbc);
        }
    }

    static {
        pStateMap.put(-1, "N/A");
        pStateMap.put(0, "Off");
        pStateMap.put(1, "On");
        pColorMap = new HashMap<Integer, Color>();
        pColorMap.put(-1, UiConstants.RED);
        pColorMap.put(0, Color.BLACK);
        pColorMap.put(1, UiConstants.GREEN);
    }

    public static interface Parent {
        public void powerResized();
    }
}

